var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
import { ActivityModel } from "./ActivityModel";
import { NetManager } from "../../manager/NetManager";
import { DataManager } from "../../manager/DataManager";
var SignModel = /** @class */ (function (_super) {
    __extends(SignModel, _super);
    function SignModel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * 签到接口
     * @param {Function} callback
     * @param {number} signActivityId 签到插件ID
     */
    SignModel.prototype.doSign = function (callback, signActivityId) {
        NetManager.ins.doSign(callback, signActivityId, DataManager.ins.petIndexData.activityId);
    };
    Object.defineProperty(SignModel.prototype, "petIndexData", {
        /**
         * 用户基础数据
         */
        get: function () {
            return DataManager.ins.petIndexData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SignModel.prototype, "petHomeInfoData", {
        /**
         * 宠物基础数据
         */
        get: function () {
            return DataManager.ins.petHomeInfoData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SignModel.prototype, "signInfoData", {
        /**
         * 签到详情数据
         */
        get: function () {
            return DataManager.ins.signInfoData;
        },
        enumerable: true,
        configurable: true
    });
    return SignModel;
}(ActivityModel));
export { SignModel };
