var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
import { DataManager } from './../../manager/DataManager';
import { NetManager } from "../../manager/NetManager";
import { ActivityModel } from "../common/ActivityModel";
var GameModel = /** @class */ (function (_super) {
    __extends(GameModel, _super);
    function GameModel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * 获取规则数据
     */
    GameModel.prototype.getRule = function (callback) {
        if (DataManager.ins.getRuleData) {
            callback(true);
        }
        else {
            NetManager.ins.getRule(callback);
        }
    };
    /**
     * 获取活动奖品数据
     */
    GameModel.prototype.getOptions = function (callback) {
        if (DataManager.ins.getOptionsData) {
            callback(true);
        }
        else {
            NetManager.ins.getOptions(callback);
        }
    };
    /**
     * 开始游戏
     * @param callback
     * @param isAgain
     * @param credits
     * @param customizedType
     */
    GameModel.prototype.doStart = function (callback, isAgain, credits, customizedType) {
        var _this = this;
        if (isAgain === void 0) { isAgain = false; }
        if (window['requirelogin']) {
            window['requirelogin']();
            return;
        }
        NetManager.ins.doStart(function (success) {
            if (success) {
                _this.getStartOrderStatus(callback, customizedType);
            }
            else {
                callback(success);
            }
        }, isAgain, credits, customizedType);
    };
    /**
     * 查询订单结果
     * @param callback
     * @param ticketId
     * @param customizedType
     */
    GameModel.prototype.getStartOrderStatus = function (callback, customizedType) {
        NetManager.ins.getStartStatus(callback, DataManager.ins.doStartData.ticketId, function () { return DataManager.ins.getStartStatusData.code != 1; }, 5, customizedType);
    };
    /**
     * 获取用户数据
     * @param callback
     */
    GameModel.prototype.getInfo = function (callback) {
        NetManager.ins.getInfo(callback);
    };
    /**
     * 获取夏日活动用户数据
     * @param callback
     */
    GameModel.prototype.getSummerInfo = function (callback, rankBaseConfigId) {
        NetManager.ins.getSummerInfo(callback, rankBaseConfigId);
    };
    /**
     * 阶段数据提交
     * @param callback
     * @param dynamicStr 数据
     */
    GameModel.prototype.datapashData = function (callback, dynamicStr) {
        NetManager.ins.datapash(null, DataManager.ins.doStartData.ticketId, dynamicStr);
    };
    /**
     * 猜扑克
     * @param callback
     * @param plugId 插件ID
     * @param ruleId 集卡规则ID
     * @param betting 0大1小2红3黑
     */
    GameModel.prototype.guessPoker = function (callback, plugId, ruleId, betting) {
        NetManager.ins.guessPoker(callback, plugId, DataManager.ins.doStartData.ticketId, ruleId, betting);
    };
    /**
     * 提交游戏成绩
     * @param callback
     * @param score 得分
     * @param allDynamics 防作弊数据
     * @param checkScore  是否校验得分
     * @param customizedType 定制类型 1推币机
     */
    GameModel.prototype.gameSubmitData = function (callback, score, allDynamics, checkScore, customizedType) {
        var _this = this;
        NetManager.ins.gameSubmit(function (success) {
            if (success) {
                _this.getSubmitResult(callback, DataManager.ins.gameSubmitData.orderId);
            }
            else {
                callback(success);
            }
        }, DataManager.ins.doStartData.ticketId, score, '[]', DataManager.ins.doStartData.submitToken, JSON.stringify(allDynamics), checkScore, customizedType);
    };
    /**
     * 查询提交结果
     * @param callback
     * @param orderId
     */
    GameModel.prototype.getSubmitResult = function (callback, orderId) {
        NetManager.ins.getSubmitResult(callback, orderId, function () {
            return DataManager.ins.gameGetSubmitResultData.flag;
        });
    };
    /**
     * 获取实时排行榜数据
     * @param callback
     * @param type 0总排行榜 1今日排行榜 2 多游戏总排行榜 3 昨日排行榜
     * @param count
     */
    GameModel.prototype.realtimerank = function (callback, type, count) {
        if (type === void 0) { type = 0; }
        if (count === void 0) { count = 30; }
        NetManager.ins.realtimerank(callback, type, count);
    };
    return GameModel;
}(ActivityModel));
export { GameModel };
