var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
import { ActivityModel } from './ActivityModel';
import { NetManager } from '../../manager/NetManager';
import { DataManager } from '../../manager/DataManager';
/**
 * 自定义活动工具业务模型
 */
var CustomModel = /** @class */ (function (_super) {
    __extends(CustomModel, _super);
    function CustomModel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * 抽奖
     * @param callback
     * @param nextStep 下一步做什么，轮询结果或者前置开奖等
     */
    CustomModel.prototype.customDoJoin = function (callback, nextStep, collectRuleId) {
        if (window['uid'] == 'not_login') {
            window['requirelogin']();
            return;
        }
        NetManager.ins.doJoin(function (success) {
            if (nextStep && success) {
                nextStep(callback);
            }
            else {
                callback(success);
            }
        }, collectRuleId);
    };
    /**
     * 获取活动工具抽奖结果
     * @param callback
     */
    CustomModel.prototype.getCustomOrderStatus = function (callback) {
        NetManager.ins.getCustomOrderStatus(callback, DataManager.ins.doJoinData.orderId, function () {
            return DataManager.ins.getCustomOrderStatusData.result == 0;
        });
    };
    /**
     * 获取前置开奖信息
     * @param callback
     */
    CustomModel.prototype.getOrderInfo = function (callback) {
        NetManager.ins.getOrderInfo(callback, DataManager.ins.doJoinData.orderId);
    };
    /**
     * 前置抽奖提交
     * @param callback
     */
    CustomModel.prototype.beforSubmit = function (callback) {
        var _this = this;
        NetManager.ins.beforSubmit(function (success) {
            if (success) {
                _this.getCustomOrderStatus(callback);
            }
            else {
                callback(success);
            }
        }, DataManager.ins.doJoinData.orderId, DataManager.ins.getOrderInfoData.facePrice);
    };
    /**
     * 闯关游戏提交
     * @param callback
     */
    CustomModel.prototype.throughSubmit = function (callback) {
        NetManager.ins.throughSubmit(callback, DataManager.ins.doJoinData.orderId);
    };
    Object.defineProperty(CustomModel.prototype, "customIsWinning", {
        /**
         * 活动工具是否中奖
         */
        get: function () {
            return DataManager.ins.getCustomOrderStatusData.lottery ? true : false;
        },
        enumerable: true,
        configurable: true
    });
    return CustomModel;
}(ActivityModel));
export { CustomModel };
