var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
import { LotteryType } from '../../enum/LotteryType';
import { NetManager } from '../../manager/NetManager';
import { DataManager } from './../../manager/DataManager';
import { Model } from './../Model';
/**
 * 兑吧活动领域模型
 */
var ActivityModel = /** @class */ (function (_super) {
    __extends(ActivityModel, _super);
    function ActivityModel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * 插件抽奖
     * @param callback
     * @param plugId
     */
    ActivityModel.prototype.plugDoJoin = function (callback, plugId) {
        var _this = this;
        NetManager.ins.doJoinPlugDraw(function (success) {
            if (success) {
                _this.getPlugOrderStatus(callback);
            }
            else {
                callback(success);
            }
        }, plugId);
    };
    /**
     * 插件抽奖订单结果
     * @param net
     */
    ActivityModel.prototype.getPlugOrderStatus = function (callback) {
        NetManager.ins.getPlugOrderStatus(callback, DataManager.ins.doJoinPlugDrawData.orderId, function () {
            return DataManager.ins.getPlugOrderStatusData.result == 0;
        });
    };
    Object.defineProperty(ActivityModel.prototype, "plugIsWinning", {
        /**
         * 插件结果弹窗
         */
        get: function () {
            return DataManager.ins.getPlugOrderStatusData.lottery ? true : false;
        },
        enumerable: true,
        configurable: true
    });
    /**
     * 曝光埋点
     */
    ActivityModel.prototype.showLog = function () {
        //曝光埋点
        if (this.lottery.imgExposure) {
            NetManager.ins.showLog(this.lottery.imgExposure);
        }
        //如果是福袋还需要推啊曝光
        if (this.lottery.type == "lucky") {
            NetManager.ins.spmshow(this.exposure);
        }
    };
    Object.defineProperty(ActivityModel.prototype, "optionImgSize", {
        /**
         * 奖品图尺寸
         */
        get: function () {
            var size;
            if (this.lottery.type == LotteryType.ALIPAY ||
                this.lottery.type == LotteryType.VIRTUAL ||
                this.lottery.type == LotteryType.OBJECT) {
                size = 's';
            }
            else {
                size = 'b';
            }
            return size;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ActivityModel.prototype, "optionImg", {
        /**
         * 奖品图片链接
         */
        get: function () {
            return this.lottery.img;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ActivityModel.prototype, "optionName", {
        /**
         * 奖品名字
         */
        get: function () {
            return this.lottery.name;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ActivityModel.prototype, "lottery", {
        /**
         * 奖品数据
         */
        get: function () {
            return;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ActivityModel.prototype, "exposure", {
        /**
         * 福袋埋点数据
         */
        get: function () {
            return;
        },
        enumerable: true,
        configurable: true
    });
    /**
     * 立即使用
     */
    ActivityModel.prototype.onUse = function () {
        if (this.lottery.type == LotteryType.COUPON || this.lottery.type == LotteryType.LUCKY) {
            window["downloadAppConfig"] =
                {
                    openUrl: this.lottery.openUrl,
                    iosDownloadUrl: this.lottery.iosDownloadUrl,
                    androidDownloadUrl: this.lottery.androidDownloadUrl,
                    confirm: this.lottery.confirm ? this.lottery.confirm : false
                };
            window["downloadApp"]();
            if (this.lottery.type == "lucky") {
                NetManager.ins.spmclick(this.exposure);
            }
        }
        else {
            window.location.href = this.lottery.link;
        }
    };
    return ActivityModel;
}(Model));
export { ActivityModel };
