import { GetVisitInfoData } from './../data/pets/GetVisitInfoData';
import { GetSummerInfoData } from './../data/game/getInfo/GetSummerInfoData';
import { GetReviveCardNumData } from './../data/game/doRevive/GetReviveCardNumData';
import { DoReviveData } from './../data/game/doRevive/DoReviveData';
import { DoJoinPlugDrawData } from './../data/plug/doJoinPlugDraw/DoJoinPlugDrawData';
import { NetName } from './../enum/NetName';
import { QuestionSubmitData } from './../data/custom/questionSbumit/QuestionSubmitData';
import { GetCollectRuleData } from './../data/common/getCollectRule/GetCollectRuleData';
import { DatapashData } from './../data/game/datapash/DatapashData';
import { OpenCollectGoodsPrizeData } from './../data/common/openCollectGoodsPrize/openCollectGoodsPrizeData';
import { TwLang } from "../util/TwLang";
import { DoStartData } from "../data/game/doStart/DoStartData";
import { GetStartStatusData } from "../data/game/doStart/GetStartStatusData";
import { GetInfoData } from "../data/game/getInfo/GetInfoData";
import { GetOptionsData } from "../data/game/getOptions/GetOptionsData";
import { GetRuleData } from "../data/game/getRule/GetRuleData";
import { GetUserTotalScoreData } from "../data/game/getUserTotalScore/GetUserTotalScoreData";
import { GuessPokerData } from "../data/game/guessPoker/GuessPokerData";
import { GameSubmitData } from "../data/game/submit/GameSubmitData";
import { RealTimeRankData } from "../data/game/realtimerank/RealTimeRankData";
import { WinRanksData } from "../data/game/winranks/WinRanksData";
import { AjaxElementData } from "../data/custom/ajaxElement/AjaxElementData";
import { DoJoinData } from "../data/custom/doJoin/DoJoinData";
import { AjaxThroughInfoData } from "../data/custom/ajaxThroughInfo/AjaxThroughInfoData";
import { GetOrderInfoData } from "../data/custom/getOrderInfo/GetOrderInfoData";
import { GetCustomOrderStatusData } from "../data/custom/doJoin/GetCustomOrderStatusData";
import { GetRoleData } from "../data/common/getRole/GetRoleData";
import { GetCreditsData } from "../data/common/getCredits/GetCreditsData";
import { AddTimesForActivityData } from "../data/common/addTimesForActivity/AddTimesForActivityData";
import { SetRoleData } from "../data/common/setRole/SetRoleData";
import { GameGetSubmitResultData } from './../data/game/submit/GameGetSubmitResultData';
import { ThroughSubmitData } from '../data/custom/throughSubmit/ThroughSubmitData';
import { BeforSubmitData } from '../data/custom/beforSubmit/BeforSubmitData';
import { PetAdopteData } from "../data/pet/PetAdopteData";
import { PetFeedData } from "../data/pet/PetFeedData";
import { PetStatusData } from "../data/pet/PetStatusData";
import { SignInfoData } from "../data/pet/SignInfoData";
import { PetHomeInfoData } from "../data/pet/PetHomeInfoData";
import { GetToysData } from "../data/pet/GetToysData";
import { ToyExchangeData } from "../data/pet/ToyExchangeData";
import { ToyUseData } from "../data/pet/ToyUseData";
import { CollectData } from "../data/pet/CollectData";
import { Data } from '../data/Data';
import { GetPlugOrderStatusData } from '../data/plug/doJoinPlugDraw/GetPlugOrderStatusData';
import { OptionInfoData } from '../data/plug/optionInfo/OptionInfoData';
import { UnblockingData } from '../data/plug/unblocking/UnblockingData';
import { GetPrizeInfoData } from '../data/plug/getPrizeInfo/GetPrizeInfoData';
// import { ABDataManager } from 'duiba-tc';
import { PetIndexData } from '../data/pet/PetIndexData';
// import { ICustomCfgData } from '..';
import { IGameCfgData } from '../data/game/cfg/IGameCfgData';
import { GetRankListData } from '../data/pet/GetRankListData';
import { GetFoodPilesData } from '../data/pet/GetFoodPilesData';
import { GetRecordData } from '../data/common/GetRecordData';
import { UseToyData } from '../data/pets/UseToyData';
import { GetActToysListData } from '../data/pets/GetActToysListData';
import { ToyExchangesData } from '../data/pets/ToyExchangesData';
import { GetUserToysListData } from '../data/pets/GetUserToysListData';
import { GetHomeInfoData } from '../data/pets/GetHomeInfoData';
import { PetsIndexData } from '../data/pets/PetsIndexData';
import { VisitStatisticsData } from '../data/pets/VisitStatisticsData';
import { VisitDetailData } from '../data/pets/VisitDetailData';
import { ABDataManager } from '../../tc/manager/ABDataManager';
import { ICustomCfgData } from '../data/custom/cfg/ICustomCfgData';
import { GetProfitDetailData } from '../data/customMade/GetProfitDetailData';
import { GooutData } from '../data/customMade/GooutData';
import { GooutRewardData } from '../data/customMade/GooutRewardData';
import { GetCollectGoodsInfoData } from '../data/common/getCollectGoodsInfo/GetCollectGoodsInfoData';
import { WeOrderData } from '../data/customMade/WeOrderData';
import { GooutResultData } from '../data/customMade/GooutResultData';
import { ToyExchangesDataXC } from '../data/pets/ToyExchangeDataXC';
import { ExchangeResultData } from '../data/pets/ExchangeResultData';
import { GetSignResultData } from '../data/pet/GetSignResultData';

/**
 *Created by cuiliqiang on 2018/3/8
 * 数据管理
 */
export class DataManager extends ABDataManager {
    private static instance: DataManager;

    public static get ins(): DataManager {
        if (!this.instance) {
            this.instance = new DataManager();
        }
        return this.instance;
    }

    private isInit: boolean;
    constructor() {
        super();
        if (this.isInit) {
            throw Error(TwLang.lang_001);
        }
        this.isInit = true;
    }

    /**
     * 游戏业务
     */
    public gameCfgData: IGameCfgData;

    /**
     * 自定义活动工具业务
     */
    public customCfgData: ICustomCfgData;

    private _getInfoData: GetInfoData;
    private _getSummerInfoData: GetSummerInfoData;
    private _getRoleData: GetRoleData;
    private _getUserTotalScoreData: GetUserTotalScoreData;
    private _getCreditsData: GetCreditsData;
    private _doStartData: DoStartData;
    private _getStartStatusData: GetStartStatusData;
    private _doReviveData: DoReviveData;
    private _getReviveCardNumData: GetReviveCardNumData;
    private _gameSubmitData: GameSubmitData;
    private _gameGetSubmitResultData: GameGetSubmitResultData;
    private _winRanksData: WinRanksData;
    private _getOptionsData: GetOptionsData;
    private _getRuleData: GetRuleData;
    private _addTimesForActivityData: AddTimesForActivityData;
    private _getCollectRuleData: GetCollectRuleData;
    private _getCollectGoodsInfoData: GetCollectGoodsInfoData;
    private _openCollectGoodsPrizeData: OpenCollectGoodsPrizeData;
    private _realTimeRankData: RealTimeRankData;
    private _doJoinPlugDrawData: DoJoinPlugDrawData;
    private _getPlugOrderStatusData: GetPlugOrderStatusData;
    private _setRoleData: SetRoleData;
    private _ajaxElementData: AjaxElementData;
    private _ajaxThroughInfoData: AjaxThroughInfoData;
    private _doJoinData: DoJoinData;
    private _getCustomOrderStatusData: GetCustomOrderStatusData;
    private _getOrderInfoData: GetOrderInfoData;
    private _throughSubmitData: ThroughSubmitData;
    private _beforSubmitData: BeforSubmitData;
    private _questionSubmitData: QuestionSubmitData;
    private _guessPokerData: GuessPokerData;
    private _optionInfoData: OptionInfoData;
    private _unblockingData: UnblockingData;
    private _datapashData: DatapashData;
    private _summerBuyPropData: any;
    private _summerOrderStatus: any;
    private _summerToyInfo: any;

    /**
     * 签到业务
     */
    public petIndexData: PetIndexData = new PetIndexData();//用户基础数据
    private _petAdopteData: PetAdopteData;
    private _petFeedData: PetFeedData;
    private _petStatusData: PetStatusData;
    private _petHomeInfoData: PetHomeInfoData;
    private _getToysData: GetToysData;//暂时不用
    private _toyExchangeData: ToyExchangeData;//暂时不用
    private _toyUseData: ToyUseData;//暂时不用
    private _collectData: CollectData;
    private _signInfoData: SignInfoData;//签到信息
    private _getSignResultData:GetSignResultData;//签到结果
    private _getRankListData: GetRankListData;//群内喂食排行榜
    private _getFoodPilesData: GetFoodPilesData;//查询待领取粮食
    private _toyExchangesDataXC :ToyExchangesDataXC;//携程购买道具(扣积分)
    private _exchangeResultData :ExchangeResultData;//携程购买道具结果轮询


    /**
     * 订制接口
     */
    // private _getProfitDetailData: GetProfitDetailData;//收入明细
    private _gooutData: GooutData;//携程宠物出行
    private _gooutResultData: GooutResultData;//携程宠物出行结果
    private _gooutRewardData: GooutRewardData;//携程宠物出行奖励
    private _weOrderData: WeOrderData;//获取用户积分流水明细
    
    /**
     * 外来宠物养成
     */
    public petsIndexData: PetsIndexData = new PetsIndexData();//外来宠物活动主页
    private _getHomeInfoData: GetHomeInfoData;//活动主信息接口
    private _getActToysListData: any = {};//商店道具接口
    private _toyExchangesData:ToyExchangesData;//道具兑换
    private _useToyData:UseToyData;//道具使用
    private _getUserToysListData:GetUserToysListData;//已购买的道具
    private _batchollectFoodData:Data;//粮食收取返回
    private _visitStatisticsData: VisitStatisticsData;//来访统计
    private _getVisitInfoData:GetVisitInfoData;//来访统计
    private _visitDetailData: VisitDetailData;//到访记录详情
    private _collectGiftRecord:Data;//礼物收取

    /**
     * 云集养狗
     */
    private _shopYunjiData:any;//商店信息

    /**
     * 插件信息列表
     */
    private _getPrizeInfoList: any = {};

    private _getRecordData:GetRecordData;

    /**
     * 更新数据
     * @param {NetName} name
     * @param result
     * @returns {any}
     */
    // tslint:disable-next-line:cyclomatic-complexity
    public updateData(name: number, result: any, param?: any): Data {
        let data: Data;
        switch (name) {
            case NetName.GET_ROLE:
                if (!this._getRoleData) {
                    this._getRoleData = new GetRoleData();
                }
                this._getRoleData.update(result);
                data = this._getRoleData;
                break;
            case NetName.GAME_TOTAL_SCORE:
                if (!this._getUserTotalScoreData) {
                    this._getUserTotalScoreData = new GetUserTotalScoreData();
                }
                this._getUserTotalScoreData.update(result);
                data = this._getUserTotalScoreData;
                break;
            case NetName.GET_CREDITS:
                if (!this._getCreditsData) {
                    this._getCreditsData = new GetCreditsData();
                }
                this._getCreditsData.update(result);
                data = this._getCreditsData;
                break;
            case NetName.GAME_INFO:
                if (!this._getInfoData) {
                    this._getInfoData = new GetInfoData();
                }
                this._getInfoData.update(result);
                data = this._getInfoData;
                break;
            case NetName.GAME_SUMMERINFO:
                if (!this._getSummerInfoData) {
                    this._getSummerInfoData = new GetSummerInfoData();
                }
                this._getSummerInfoData.update(result);
                data = this._getSummerInfoData;
                break;
            case NetName.GAME_START:
                if (!this._doStartData) {
                    this._doStartData = new DoStartData();
                }
                this._doStartData.update(result);
                data = this._doStartData;
                break;
            case NetName.GAME_START_STATUS:
                if (!this._getStartStatusData) {
                    this._getStartStatusData = new GetStartStatusData();
                }
                this._getStartStatusData.update(result);
                data = this._getStartStatusData;
                break;
            case NetName.GAME_REVIVE:
                if (!this._doReviveData) {
                    this._doReviveData = new DoReviveData();
                }
                this._doReviveData.update(result);
                data = this._doReviveData;
                break;
            case NetName.GAME_REVIVE_STATUS:
                if (!this._getReviveCardNumData) {
                    this._getReviveCardNumData = new GetReviveCardNumData();
                }
                this._getReviveCardNumData.update(result);
                data = this._getReviveCardNumData;
                break;
            case NetName.GAME_SUBMIT:
                if (!this._gameSubmitData) {
                    this._gameSubmitData = new GameSubmitData();
                }
                this._gameSubmitData.update(result);
                data = this._gameSubmitData;

                if (result.data) {
                    this._getInfoData.update(result);
                }
                break;
            case NetName.GAME_SUBMIT_STATUS:
                if (!this._gameGetSubmitResultData) {
                    this._gameGetSubmitResultData = new GameGetSubmitResultData();
                }
                this._gameGetSubmitResultData.update(result);
                data = this._gameGetSubmitResultData;
                break;
            case NetName.GAME_RANKS:
                if (!this._winRanksData) {
                    this._winRanksData = new WinRanksData();
                }
                this._winRanksData.update(result);
                data = this._winRanksData;
                break;
            case NetName.GAME_OPTIONS:
                if (!this._getOptionsData) {
                    this._getOptionsData = new GetOptionsData();
                }
                this._getOptionsData.update(result);
                data = this._getOptionsData;
                break;
            case NetName.GAME_RULE:
                if (!this._getRuleData) {
                    this._getRuleData = new GetRuleData();
                }
                this._getRuleData.update(result);
                data = this._getRuleData;
                break;
            case NetName.ADD_TIMES:
                if (!this._addTimesForActivityData) {
                    this._addTimesForActivityData = new AddTimesForActivityData();
                }
                this._addTimesForActivityData.update(result);
                data = this._addTimesForActivityData;
                break;
            case NetName.COLLECT_RULE:
                if (!this._getCollectRuleData) {
                    this._getCollectRuleData = new GetCollectRuleData();
                }
                this._getCollectRuleData.update(result);
                data = this._getCollectRuleData;
                break;
            case NetName.COLLECT_GOODS_INFO:    //集卡详情
                if (!this._getCollectGoodsInfoData) {
                    this._getCollectGoodsInfoData = new GetCollectGoodsInfoData();
                }
                this._getCollectGoodsInfoData.update(result);
                data = this._getCollectGoodsInfoData;
                break;
            case NetName.OPEN_COLLECT:
                if (!this._openCollectGoodsPrizeData) {
                    this._openCollectGoodsPrizeData = new OpenCollectGoodsPrizeData();
                }
                this._openCollectGoodsPrizeData.update(result);
                data = this._openCollectGoodsPrizeData;
                break;
            case NetName.GAME_REAL_TIME_RANK:
                if (!this._realTimeRankData) {
                    this._realTimeRankData = new RealTimeRankData();
                }
                this._realTimeRankData.update(result);
                data = this._realTimeRankData;
                break;
            case NetName.PLUG_DO_JOIN:
                if (!this._doJoinPlugDrawData) {
                    this._doJoinPlugDrawData = new DoJoinPlugDrawData();
                }
                this._doJoinPlugDrawData.update(result);
                data = this._doJoinPlugDrawData;
                break;
            case NetName.PLUG_ORDER_STATUS:
                if (!this._getPlugOrderStatusData) {
                    this._getPlugOrderStatusData = new GetPlugOrderStatusData();
                }
                this._getPlugOrderStatusData.update(result);
                data = this._getPlugOrderStatusData;
                break;
            case NetName.PLUG_PRIZE_INFO://查询插件信息
                const plugID = param.activityId;
                if (!this._getPrizeInfoList[plugID]) {
                    this._getPrizeInfoList[plugID] = new GetPrizeInfoData();
                }
                this._getPrizeInfoList[plugID].update(result);
                data = this._getPrizeInfoList[plugID];
                break;
            case NetName.SET_ROLE:
                if (!this._setRoleData) {
                    this._setRoleData = new SetRoleData();
                }
                this._setRoleData.update(result);
                data = this._setRoleData;
                break;
            case NetName.CUSTOM_ELEMENT:
                if (!this._ajaxElementData) {
                    this._ajaxElementData = new AjaxElementData();
                }
                this._ajaxElementData.update(result);
                data = this._ajaxElementData;
                break;
            case NetName.CUSTOM_THROUGH_INFO:
                if (!this._ajaxThroughInfoData) {
                    this._ajaxThroughInfoData = new AjaxThroughInfoData();
                }
                this._ajaxThroughInfoData.update(result);
                data = this._ajaxThroughInfoData;
                break;
            case NetName.CUSTOM_DO_JOIN:
                if (!this._doJoinData) {
                    this._doJoinData = new DoJoinData();
                }
                this._doJoinData.update(result);
                data = this._doJoinData;
                break;
            case NetName.CUSTOM_ORDER_STATUS:
                if (!this._getCustomOrderStatusData) {
                    this._getCustomOrderStatusData = new GetCustomOrderStatusData();
                }
                this._getCustomOrderStatusData.update(result);
                data = this._getCustomOrderStatusData;

                this._ajaxElementData.element = result.element;
                break;
            case NetName.CUSTOM_ORDER_INFO:
                if (!this._getOrderInfoData) {
                    this._getOrderInfoData = new GetOrderInfoData();
                }
                this._getOrderInfoData.update(result);
                data = this._getOrderInfoData;
                break;
            case NetName.CUSTOM_THROUGH_SUBMIT:
                if (!this._throughSubmitData) {
                    this._throughSubmitData = new ThroughSubmitData();
                }
                this._throughSubmitData.update(result);
                data = this._throughSubmitData;
                break;
            case NetName.CUSTOM_BEFOR_SUBMIT:
                if (!this._beforSubmitData) {
                    this._beforSubmitData = new BeforSubmitData();
                }
                this._beforSubmitData.update(result);
                data = this._beforSubmitData;
                break;
            case NetName.CUSTOM_QUESTION_SUBMIT:
                if (!this._questionSubmitData) {
                    this._questionSubmitData = new QuestionSubmitData();
                }
                this._questionSubmitData.update(result);
                data = this._questionSubmitData;
                break;
            case NetName.GAME_GUESS_POKER:
                if (!this._guessPokerData) {
                    this._guessPokerData = new GuessPokerData();
                }
                this._guessPokerData.update(result);
                data = this._guessPokerData;
                break;
            case NetName.PLUG_OPTION_INFO:
                if (!this._optionInfoData) {
                    this._optionInfoData = new OptionInfoData();
                }
                this._optionInfoData.update(result);
                data = this._optionInfoData;
                break;
            case NetName.SIGN_INFO://查询签到信息接口
            case NetName.SIGN_DO_SIGN://签到接口
                if (!this._signInfoData) {
                    this._signInfoData = new SignInfoData();
                }
                this._signInfoData.update(result);
                data = this._signInfoData;
                break;
            case NetName.GET_SIGN_RESULT://签到结果查询(轮询)
                
                if (!this._getSignResultData) {
                    this._getSignResultData = new GetSignResultData();
                }
                this._getSignResultData.update(result);
                data = this._getSignResultData;
                break;
            case NetName.WE_ORDER://获取用户积分流水明细
                if(!this._weOrderData){
                    this._weOrderData = new WeOrderData();
                }
                this._weOrderData.update(result);
                data = this._weOrderData;
                break;

            case NetName.PLUG_UNBLOCKING:
                if (!this._unblockingData) {
                    this._unblockingData = new UnblockingData();
                }
                this._unblockingData.update(result);
                data = this._unblockingData;
                break;
            case NetName.GAME_DATA_PASH:
                if (!this._datapashData) {
                    this._datapashData = new DatapashData();
                }
                this._datapashData.update(result);
                data = this._datapashData;
                break;
            case NetName.GAME_SUMMER_BUYPROP:
                this._summerBuyPropData = result;
                data = result;
                break;
            case NetName.GAME_SUMMER_GET_ORDER_STATUS:
                this._summerOrderStatus = result;
                data = result;
                break;
            case NetName.GAME_SUMMER_GET_TOY_INFO:
                this._summerToyInfo = result;
                data = result;
                break;
            case NetName.GET_RECORD://查询我的奖品记录
                if(!this._getRecordData){
                    this._getRecordData = new GetRecordData();
                }
                this._getRecordData.update(result);
                data = this._getRecordData;
                break;
                
            case NetName.SHOP_YUNJI:
                this._shopYunjiData = result;
                data = this._shopYunjiData;
                break;
            default:
                this[this.getKey(name)]=result;
        }
        return data || result;
    }

    getData(name){
        return this[this.getKey(name)]
    }

    private getKey(name){
        return `_tw_data_${name}_`
    }

    /**
     * 用户信息
     */
    public get getInfoData(): GetInfoData {
        return this._getInfoData;
    }

    /**
     * 夏日活动用户信息
     */
    public get getSummerInfoData(): GetSummerInfoData {
        return this._getSummerInfoData;
    }

    /**
     * 角色信息
     */
    public get getRoleData(): GetRoleData {
        return this._getRoleData;
    }

    /**
     * 用户成长值
     */
    public get getUserTotalScoreData(): GetUserTotalScoreData {
        return this._getUserTotalScoreData;
    }

    /**
     * 用户积分
     */
    public get getCreditsData(): GetCreditsData {
        return this._getCreditsData;
    }

    /**
     * 开始游戏
     */
    public get doStartData(): DoStartData {
        return this._doStartData;
    }
    /**
     * 开始游戏订单结果
     */
    public get getStartStatusData(): GetStartStatusData {
        return this._getStartStatusData;
    }

    /**
     * 复活
     */
    public get doReviveData(): DoReviveData {
        return this._doReviveData;
    }

    /**
     * 获得复活卡数量
     */
    public get getReviveCardNumData(): GetReviveCardNumData {
        return this._getReviveCardNumData;
    }
    /**
     * 游戏提交
     */
    public get gameSubmitData(): GameSubmitData {
        return this._gameSubmitData;
    }

    /**
     * 游戏提交订单结果
     */
    public get gameGetSubmitResultData(): GameGetSubmitResultData {
        return this._gameGetSubmitResultData;
    }

    /**
     * 开奖
     */
    public get winRanksData(): WinRanksData {
        return this._winRanksData;
    }

    /**
     * 游戏奖品
     */
    public get getOptionsData(): GetOptionsData {
        return this._getOptionsData;
    }

    /**
     * 游戏规则
     */
    public get getRuleData(): GetRuleData {
        return this._getRuleData;
    }

    /**
     * 活动次数
     */
    public get addTimesForActivityData(): AddTimesForActivityData {
        return this._addTimesForActivityData;
    }

    /**
     * 集卡规则
     */
    public get getCollectRuleData(): GetCollectRuleData {
        return this._getCollectRuleData;
    }

    /**
     * 集卡详情
     */
    public get getCollectGoodsInfoData(): GetCollectGoodsInfoData {
        return this._getCollectGoodsInfoData;
    }
    
    /**
     * 集卡开奖
     */
    public get openCollectGoodsPrizeData(): OpenCollectGoodsPrizeData {
        return this._openCollectGoodsPrizeData;
    }

    /**
     * 实时排行榜
     */
    public get realTimeRankData(): RealTimeRankData {
        return this._realTimeRankData;
    }

    /**
     * 插件
     */
    public get doJoinPlugDrawData(): DoJoinPlugDrawData {
        return this._doJoinPlugDrawData;
    }

    /**
     * 插件订单结果
     */
    public get getPlugOrderStatusData(): GetPlugOrderStatusData {
        return this._getPlugOrderStatusData;
    }

    /**
     * 设置角色
     */
    public get setRoleData(): SetRoleData {
        return this._setRoleData;
    }

    /**
     * 活动工具基础信息
     */
    public get ajaxElementData(): AjaxElementData {
        return this._ajaxElementData;
    }

    /**
     * 闯关游戏基础信息
     */
    public get ajaxThroughInfoData(): AjaxThroughInfoData {
        return this._ajaxThroughInfoData;
    }

    /**
     * 活动工具抽奖
     */
    public get doJoinData(): DoJoinData {
        return this._doJoinData;
    }

    /**
     * 活动工具订单结果
     */
    public get getCustomOrderStatusData(): GetCustomOrderStatusData {
        return this._getCustomOrderStatusData;
    }

    /**
     * 前置抽奖
     */
    public get getOrderInfoData(): GetOrderInfoData {
        return this._getOrderInfoData;
    }

    /**
     * 闯关游戏提交
     */
    public get throughSubmitData(): ThroughSubmitData {
        return this._throughSubmitData;
    }

    /**
     * 前置开奖提交
     */
    public get beforSubmitData(): BeforSubmitData {
        return this._beforSubmitData;
    }

    /**
     * 答题提交
     */
    public get questionSubmitData(): QuestionSubmitData {
        return this._questionSubmitData;
    }

    /**
     * 猜扑克
     */
    public get guessPokerData(): GuessPokerData {
        return this._guessPokerData;
    }

    /**
     * 插件奖品信息
     */
    public get optionInfoData(): OptionInfoData {
        return this._optionInfoData;
    }

    /**
     * 解锁插件
     */
    public get unblockingData(): UnblockingData {
        return this._unblockingData;
    }

    /**
     * 防作弊阶段提交
     */
    public get datapashData(): DatapashData {
        return this._datapashData;
    }

    public get summerBuyPropData(): any {
        return this._summerBuyPropData;
    }
    public get summerOrderStatus(): any {
        return this._summerOrderStatus;
    }
    public get summerToyInfo(): any {
        return this._summerToyInfo;
    }

    /**
     * 养成
     * 宠物基础数据
     */
    public get petHomeInfoData(): PetHomeInfoData {
        return this._petHomeInfoData;
    }

    /**
     * 取名字界面数据
     */
    public get petAdopteData(): PetAdopteData{
        return this._petAdopteData;
    }

    /**
     * 养成
     * 宠物喂食回调数据
     */
    public get petFeedData(): PetFeedData {
        return this._petFeedData;
    }

    /**
     * 养成
     * 签到信息
     */
    public get signInfoData(): SignInfoData {
        return this._signInfoData;
    }
    /**
     * 养成
     * 签到结果轮询信息
     */
    public get getSignResultData(): GetSignResultData{
        return this._getSignResultData;
    }

    /**
     * 养成
     * 刷新宠物状态
     */
    public get petStatusData(): PetStatusData{
        return this._petStatusData;
    }


    /**
     * 插件列表
     */
    public get getPrizeInfoList(): any {
        return this._getPrizeInfoList;
    }

    /**
     * 喂养排名信息
     */
    public get getRankListData(): GetRankListData {
        return this._getRankListData;
    }

    /**
     * 查询待领取粮食信息
     */
    public get getFoodPilesData(): GetFoodPilesData {
        return this._getFoodPilesData;
    }

    /**
     * 购买道具携程(积分购买)
     */
    public get toyExchangesDataXC():ToyExchangesDataXC{
        return this._toyExchangesDataXC;
    }

    /**
     * 查询我的奖品记录
     */
    public get getRecordData():GetRecordData{
        return this._getRecordData;
    }
    /**
     * 外来宠物养成--活动主信息接口
     */
    public get getHomeInfoData():GetHomeInfoData{
        return this._getHomeInfoData;
    }

    public set getHomeInfoData(d:GetHomeInfoData){
        this._getHomeInfoData = d;
    }

    /**
     * 收取猫草回调数据
     */
    public get gtBatchollectFoodData():Data{
        return this._batchollectFoodData;
    }


    /**
     * 外来宠物养成--商店道具列表
     * _getActToysListData是个object，根据类型归类存放数据
     * _getActToysListData[type] = GetActToysListData
     * type: 1食物，2道具，3...
     */
    public get getActToysListData(): any{
        return this._getActToysListData;
    }

    public set getActToysListData(d: any){
        this._getActToysListData = d;
    }

    /**
     * 外来宠物养成--我的道具列表
     */
    public get getUserToysListData():GetUserToysListData{
        return this._getUserToysListData;
    }

    public set getUserToysListData(d:GetUserToysListData){
        this._getUserToysListData = d;
    }

    /**
     * 外来宠物养成--来访统计
     */
    public get visitStatisticsData():VisitStatisticsData{
        return this._visitStatisticsData;
    }

    /**
     * 外来宠物养成--动态信息列表
     */
    public get getVisitInfoData():GetVisitInfoData{
        return this._getVisitInfoData;
    }

    /**
     * 外来宠物养成--到访记录详情
     */
    public get visitDetailData():VisitDetailData{
        return this._visitDetailData;
    }

    /**
     * 外来宠物养成--礼物收取
     */
    public get collectGiftRecord():Data{
        return this._collectGiftRecord;
    }
    
    // /**
    //  * 订制接口-收入明细
    //  */
    // public get getProfitDetailData():GetProfitDetailData{
    //     return this._getProfitDetailData;
    // }
    
    /**
     * 订制接口-携程宠物出行
     */
    public get gooutData():GooutData{
        return this._gooutData;
    }
    
    /**
     * 订制接口-携程宠物出行结果
     */
    public get gooutResultData():GooutResultData{
        return this._gooutResultData;
    }
    
    /**
     * 订制接口-携程宠物出行奖励
     */
    public get gooutRewardData():GooutRewardData{
        return this._gooutRewardData;
    }
    
    /**
     * 订制接口-获取用户积分流水明细
     */
    public get weOrderData():WeOrderData{
        return this._weOrderData;
    }
    // tslint:disable-next-line:max-file-line-count

    /**
     * 商店数据云集
     */
    public get shopYunjiData():any{
        return this._shopYunjiData;
    }

}