var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
import { GetSummerInfoData } from './../data/game/getInfo/GetSummerInfoData';
import { GetReviveCardNumData } from './../data/game/doRevive/GetReviveCardNumData';
import { DoReviveData } from './../data/game/doRevive/DoReviveData';
import { DoJoinPlugDrawData } from './../data/plug/doJoinPlugDraw/DoJoinPlugDrawData';
import { NetName } from './../enum/NetName';
import { QuestionSubmitData } from './../data/custom/questionSbumit/QuestionSubmitData';
import { GetCollectRuleData } from './../data/common/getCollectRule/GetCollectRuleData';
import { DatapashData } from './../data/game/datapash/DatapashData';
import { OpenCollectGoodsPrizeData } from './../data/common/openCollectGoodsPrize/openCollectGoodsPrizeData';
import { TwLang } from "../util/TwLang";
import { DoStartData } from "../data/game/doStart/DoStartData";
import { GetStartStatusData } from "../data/game/doStart/GetStartStatusData";
import { GetInfoData } from "../data/game/getInfo/GetInfoData";
import { GetOptionsData } from "../data/game/getOptions/GetOptionsData";
import { GetRuleData } from "../data/game/getRule/GetRuleData";
import { GetUserTotalScoreData } from "../data/game/getUserTotalScore/GetUserTotalScoreData";
import { GuessPokerData } from "../data/game/guessPoker/GuessPokerData";
import { GameSubmitData } from "../data/game/submit/GameSubmitData";
import { RealTimeRankData } from "../data/game/realtimerank/RealTimeRankData";
import { WinRanksData } from "../data/game/winranks/WinRanksData";
import { AjaxElementData } from "../data/custom/ajaxElement/AjaxElementData";
import { DoJoinData } from "../data/custom/doJoin/DoJoinData";
import { AjaxThroughInfoData } from "../data/custom/ajaxThroughInfo/AjaxThroughInfoData";
import { GetOrderInfoData } from "../data/custom/getOrderInfo/GetOrderInfoData";
import { GetCustomOrderStatusData } from "../data/custom/doJoin/GetCustomOrderStatusData";
import { GetRoleData } from "../data/common/getRole/GetRoleData";
import { GetCreditsData } from "../data/common/getCredits/GetCreditsData";
import { AddTimesForActivityData } from "../data/common/addTimesForActivity/AddTimesForActivityData";
import { SetRoleData } from "../data/common/setRole/SetRoleData";
import { GameGetSubmitResultData } from './../data/game/submit/GameGetSubmitResultData';
import { ThroughSubmitData } from '../data/custom/throughSubmit/ThroughSubmitData';
import { BeforSubmitData } from '../data/custom/beforSubmit/BeforSubmitData';
import { SignInfoData } from "../data/pet/SignInfoData";
import { GetPlugOrderStatusData } from '../data/plug/doJoinPlugDraw/GetPlugOrderStatusData';
import { OptionInfoData } from '../data/plug/optionInfo/OptionInfoData';
import { UnblockingData } from '../data/plug/unblocking/UnblockingData';
import { GetPrizeInfoData } from '../data/plug/getPrizeInfo/GetPrizeInfoData';
// import { ABDataManager } from 'duiba-tc';
import { PetIndexData } from '../data/pet/PetIndexData';
import { GetRecordData } from '../data/common/GetRecordData';
import { PetsIndexData } from '../data/pets/PetsIndexData';
import { ABDataManager } from '../../tc/manager/ABDataManager';
import { GetCollectGoodsInfoData } from '../data/common/getCollectGoodsInfo/GetCollectGoodsInfoData';
import { WeOrderData } from '../data/customMade/WeOrderData';
import { GetSignResultData } from '../data/pet/GetSignResultData';
/**
 *Created by cuiliqiang on 2018/3/8
 * 数据管理
 */
var DataManager = /** @class */ (function (_super) {
    __extends(DataManager, _super);
    function DataManager() {
        var _this = _super.call(this) || this;
        /**
         * 签到业务
         */
        _this.petIndexData = new PetIndexData(); //用户基础数据
        /**
         * 外来宠物养成
         */
        _this.petsIndexData = new PetsIndexData(); //外来宠物活动主页
        _this._getActToysListData = {}; //商店道具接口
        /**
         * 插件信息列表
         */
        _this._getPrizeInfoList = {};
        if (_this.isInit) {
            throw Error(TwLang.lang_001);
        }
        _this.isInit = true;
        return _this;
    }
    Object.defineProperty(DataManager, "ins", {
        get: function () {
            if (!this.instance) {
                this.instance = new DataManager();
            }
            return this.instance;
        },
        enumerable: true,
        configurable: true
    });
    /**
     * 更新数据
     * @param {NetName} name
     * @param result
     * @returns {any}
     */
    // tslint:disable-next-line:cyclomatic-complexity
    DataManager.prototype.updateData = function (name, result, param) {
        var data;
        switch (name) {
            case NetName.GET_ROLE:
                if (!this._getRoleData) {
                    this._getRoleData = new GetRoleData();
                }
                this._getRoleData.update(result);
                data = this._getRoleData;
                break;
            case NetName.GAME_TOTAL_SCORE:
                if (!this._getUserTotalScoreData) {
                    this._getUserTotalScoreData = new GetUserTotalScoreData();
                }
                this._getUserTotalScoreData.update(result);
                data = this._getUserTotalScoreData;
                break;
            case NetName.GET_CREDITS:
                if (!this._getCreditsData) {
                    this._getCreditsData = new GetCreditsData();
                }
                this._getCreditsData.update(result);
                data = this._getCreditsData;
                break;
            case NetName.GAME_INFO:
                if (!this._getInfoData) {
                    this._getInfoData = new GetInfoData();
                }
                this._getInfoData.update(result);
                data = this._getInfoData;
                break;
            case NetName.GAME_SUMMERINFO:
                if (!this._getSummerInfoData) {
                    this._getSummerInfoData = new GetSummerInfoData();
                }
                this._getSummerInfoData.update(result);
                data = this._getSummerInfoData;
                break;
            case NetName.GAME_START:
                if (!this._doStartData) {
                    this._doStartData = new DoStartData();
                }
                this._doStartData.update(result);
                data = this._doStartData;
                break;
            case NetName.GAME_START_STATUS:
                if (!this._getStartStatusData) {
                    this._getStartStatusData = new GetStartStatusData();
                }
                this._getStartStatusData.update(result);
                data = this._getStartStatusData;
                break;
            case NetName.GAME_REVIVE:
                if (!this._doReviveData) {
                    this._doReviveData = new DoReviveData();
                }
                this._doReviveData.update(result);
                data = this._doReviveData;
                break;
            case NetName.GAME_REVIVE_STATUS:
                if (!this._getReviveCardNumData) {
                    this._getReviveCardNumData = new GetReviveCardNumData();
                }
                this._getReviveCardNumData.update(result);
                data = this._getReviveCardNumData;
                break;
            case NetName.GAME_SUBMIT:
                if (!this._gameSubmitData) {
                    this._gameSubmitData = new GameSubmitData();
                }
                this._gameSubmitData.update(result);
                data = this._gameSubmitData;
                if (result.data) {
                    this._getInfoData.update(result);
                }
                break;
            case NetName.GAME_SUBMIT_STATUS:
                if (!this._gameGetSubmitResultData) {
                    this._gameGetSubmitResultData = new GameGetSubmitResultData();
                }
                this._gameGetSubmitResultData.update(result);
                data = this._gameGetSubmitResultData;
                break;
            case NetName.GAME_RANKS:
                if (!this._winRanksData) {
                    this._winRanksData = new WinRanksData();
                }
                this._winRanksData.update(result);
                data = this._winRanksData;
                break;
            case NetName.GAME_OPTIONS:
                if (!this._getOptionsData) {
                    this._getOptionsData = new GetOptionsData();
                }
                this._getOptionsData.update(result);
                data = this._getOptionsData;
                break;
            case NetName.GAME_RULE:
                if (!this._getRuleData) {
                    this._getRuleData = new GetRuleData();
                }
                this._getRuleData.update(result);
                data = this._getRuleData;
                break;
            case NetName.ADD_TIMES:
                if (!this._addTimesForActivityData) {
                    this._addTimesForActivityData = new AddTimesForActivityData();
                }
                this._addTimesForActivityData.update(result);
                data = this._addTimesForActivityData;
                break;
            case NetName.COLLECT_RULE:
                if (!this._getCollectRuleData) {
                    this._getCollectRuleData = new GetCollectRuleData();
                }
                this._getCollectRuleData.update(result);
                data = this._getCollectRuleData;
                break;
            case NetName.COLLECT_GOODS_INFO: //集卡详情
                if (!this._getCollectGoodsInfoData) {
                    this._getCollectGoodsInfoData = new GetCollectGoodsInfoData();
                }
                this._getCollectGoodsInfoData.update(result);
                data = this._getCollectGoodsInfoData;
                break;
            case NetName.OPEN_COLLECT:
                if (!this._openCollectGoodsPrizeData) {
                    this._openCollectGoodsPrizeData = new OpenCollectGoodsPrizeData();
                }
                this._openCollectGoodsPrizeData.update(result);
                data = this._openCollectGoodsPrizeData;
                break;
            case NetName.GAME_REAL_TIME_RANK:
                if (!this._realTimeRankData) {
                    this._realTimeRankData = new RealTimeRankData();
                }
                this._realTimeRankData.update(result);
                data = this._realTimeRankData;
                break;
            case NetName.PLUG_DO_JOIN:
                if (!this._doJoinPlugDrawData) {
                    this._doJoinPlugDrawData = new DoJoinPlugDrawData();
                }
                this._doJoinPlugDrawData.update(result);
                data = this._doJoinPlugDrawData;
                break;
            case NetName.PLUG_ORDER_STATUS:
                if (!this._getPlugOrderStatusData) {
                    this._getPlugOrderStatusData = new GetPlugOrderStatusData();
                }
                this._getPlugOrderStatusData.update(result);
                data = this._getPlugOrderStatusData;
                break;
            case NetName.PLUG_PRIZE_INFO: //查询插件信息
                var plugID = param.activityId;
                if (!this._getPrizeInfoList[plugID]) {
                    this._getPrizeInfoList[plugID] = new GetPrizeInfoData();
                }
                this._getPrizeInfoList[plugID].update(result);
                data = this._getPrizeInfoList[plugID];
                break;
            case NetName.SET_ROLE:
                if (!this._setRoleData) {
                    this._setRoleData = new SetRoleData();
                }
                this._setRoleData.update(result);
                data = this._setRoleData;
                break;
            case NetName.CUSTOM_ELEMENT:
                if (!this._ajaxElementData) {
                    this._ajaxElementData = new AjaxElementData();
                }
                this._ajaxElementData.update(result);
                data = this._ajaxElementData;
                break;
            case NetName.CUSTOM_THROUGH_INFO:
                if (!this._ajaxThroughInfoData) {
                    this._ajaxThroughInfoData = new AjaxThroughInfoData();
                }
                this._ajaxThroughInfoData.update(result);
                data = this._ajaxThroughInfoData;
                break;
            case NetName.CUSTOM_DO_JOIN:
                if (!this._doJoinData) {
                    this._doJoinData = new DoJoinData();
                }
                this._doJoinData.update(result);
                data = this._doJoinData;
                break;
            case NetName.CUSTOM_ORDER_STATUS:
                if (!this._getCustomOrderStatusData) {
                    this._getCustomOrderStatusData = new GetCustomOrderStatusData();
                }
                this._getCustomOrderStatusData.update(result);
                data = this._getCustomOrderStatusData;
                this._ajaxElementData.element = result.element;
                break;
            case NetName.CUSTOM_ORDER_INFO:
                if (!this._getOrderInfoData) {
                    this._getOrderInfoData = new GetOrderInfoData();
                }
                this._getOrderInfoData.update(result);
                data = this._getOrderInfoData;
                break;
            case NetName.CUSTOM_THROUGH_SUBMIT:
                if (!this._throughSubmitData) {
                    this._throughSubmitData = new ThroughSubmitData();
                }
                this._throughSubmitData.update(result);
                data = this._throughSubmitData;
                break;
            case NetName.CUSTOM_BEFOR_SUBMIT:
                if (!this._beforSubmitData) {
                    this._beforSubmitData = new BeforSubmitData();
                }
                this._beforSubmitData.update(result);
                data = this._beforSubmitData;
                break;
            case NetName.CUSTOM_QUESTION_SUBMIT:
                if (!this._questionSubmitData) {
                    this._questionSubmitData = new QuestionSubmitData();
                }
                this._questionSubmitData.update(result);
                data = this._questionSubmitData;
                break;
            case NetName.GAME_GUESS_POKER:
                if (!this._guessPokerData) {
                    this._guessPokerData = new GuessPokerData();
                }
                this._guessPokerData.update(result);
                data = this._guessPokerData;
                break;
            case NetName.PLUG_OPTION_INFO:
                if (!this._optionInfoData) {
                    this._optionInfoData = new OptionInfoData();
                }
                this._optionInfoData.update(result);
                data = this._optionInfoData;
                break;
            case NetName.SIGN_INFO: //查询签到信息接口
            case NetName.SIGN_DO_SIGN: //签到接口
                if (!this._signInfoData) {
                    this._signInfoData = new SignInfoData();
                }
                this._signInfoData.update(result);
                data = this._signInfoData;
                break;
            case NetName.GET_SIGN_RESULT: //签到结果查询(轮询)
                if (!this._getSignResultData) {
                    this._getSignResultData = new GetSignResultData();
                }
                this._getSignResultData.update(result);
                data = this._getSignResultData;
                break;
            case NetName.WE_ORDER: //获取用户积分流水明细
                if (!this._weOrderData) {
                    this._weOrderData = new WeOrderData();
                }
                this._weOrderData.update(result);
                data = this._weOrderData;
                break;
            case NetName.PLUG_UNBLOCKING:
                if (!this._unblockingData) {
                    this._unblockingData = new UnblockingData();
                }
                this._unblockingData.update(result);
                data = this._unblockingData;
                break;
            case NetName.GAME_DATA_PASH:
                if (!this._datapashData) {
                    this._datapashData = new DatapashData();
                }
                this._datapashData.update(result);
                data = this._datapashData;
                break;
            case NetName.GAME_SUMMER_BUYPROP:
                this._summerBuyPropData = result;
                data = result;
                break;
            case NetName.GAME_SUMMER_GET_ORDER_STATUS:
                this._summerOrderStatus = result;
                data = result;
                break;
            case NetName.GAME_SUMMER_GET_TOY_INFO:
                this._summerToyInfo = result;
                data = result;
                break;
            case NetName.GET_RECORD: //查询我的奖品记录
                if (!this._getRecordData) {
                    this._getRecordData = new GetRecordData();
                }
                this._getRecordData.update(result);
                data = this._getRecordData;
                break;
            case NetName.SHOP_YUNJI:
                this._shopYunjiData = result;
                data = this._shopYunjiData;
                break;
            default:
                this[this.getKey(name)] = result;
        }
        return data || result;
    };
    DataManager.prototype.getData = function (name) {
        return this[this.getKey(name)];
    };
    DataManager.prototype.getKey = function (name) {
        return "_tw_data_" + name + "_";
    };
    Object.defineProperty(DataManager.prototype, "getInfoData", {
        /**
         * 用户信息
         */
        get: function () {
            return this._getInfoData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "getSummerInfoData", {
        /**
         * 夏日活动用户信息
         */
        get: function () {
            return this._getSummerInfoData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "getRoleData", {
        /**
         * 角色信息
         */
        get: function () {
            return this._getRoleData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "getUserTotalScoreData", {
        /**
         * 用户成长值
         */
        get: function () {
            return this._getUserTotalScoreData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "getCreditsData", {
        /**
         * 用户积分
         */
        get: function () {
            return this._getCreditsData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "doStartData", {
        /**
         * 开始游戏
         */
        get: function () {
            return this._doStartData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "getStartStatusData", {
        /**
         * 开始游戏订单结果
         */
        get: function () {
            return this._getStartStatusData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "doReviveData", {
        /**
         * 复活
         */
        get: function () {
            return this._doReviveData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "getReviveCardNumData", {
        /**
         * 获得复活卡数量
         */
        get: function () {
            return this._getReviveCardNumData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "gameSubmitData", {
        /**
         * 游戏提交
         */
        get: function () {
            return this._gameSubmitData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "gameGetSubmitResultData", {
        /**
         * 游戏提交订单结果
         */
        get: function () {
            return this._gameGetSubmitResultData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "winRanksData", {
        /**
         * 开奖
         */
        get: function () {
            return this._winRanksData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "getOptionsData", {
        /**
         * 游戏奖品
         */
        get: function () {
            return this._getOptionsData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "getRuleData", {
        /**
         * 游戏规则
         */
        get: function () {
            return this._getRuleData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "addTimesForActivityData", {
        /**
         * 活动次数
         */
        get: function () {
            return this._addTimesForActivityData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "getCollectRuleData", {
        /**
         * 集卡规则
         */
        get: function () {
            return this._getCollectRuleData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "getCollectGoodsInfoData", {
        /**
         * 集卡详情
         */
        get: function () {
            return this._getCollectGoodsInfoData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "openCollectGoodsPrizeData", {
        /**
         * 集卡开奖
         */
        get: function () {
            return this._openCollectGoodsPrizeData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "realTimeRankData", {
        /**
         * 实时排行榜
         */
        get: function () {
            return this._realTimeRankData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "doJoinPlugDrawData", {
        /**
         * 插件
         */
        get: function () {
            return this._doJoinPlugDrawData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "getPlugOrderStatusData", {
        /**
         * 插件订单结果
         */
        get: function () {
            return this._getPlugOrderStatusData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "setRoleData", {
        /**
         * 设置角色
         */
        get: function () {
            return this._setRoleData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "ajaxElementData", {
        /**
         * 活动工具基础信息
         */
        get: function () {
            return this._ajaxElementData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "ajaxThroughInfoData", {
        /**
         * 闯关游戏基础信息
         */
        get: function () {
            return this._ajaxThroughInfoData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "doJoinData", {
        /**
         * 活动工具抽奖
         */
        get: function () {
            return this._doJoinData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "getCustomOrderStatusData", {
        /**
         * 活动工具订单结果
         */
        get: function () {
            return this._getCustomOrderStatusData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "getOrderInfoData", {
        /**
         * 前置抽奖
         */
        get: function () {
            return this._getOrderInfoData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "throughSubmitData", {
        /**
         * 闯关游戏提交
         */
        get: function () {
            return this._throughSubmitData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "beforSubmitData", {
        /**
         * 前置开奖提交
         */
        get: function () {
            return this._beforSubmitData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "questionSubmitData", {
        /**
         * 答题提交
         */
        get: function () {
            return this._questionSubmitData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "guessPokerData", {
        /**
         * 猜扑克
         */
        get: function () {
            return this._guessPokerData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "optionInfoData", {
        /**
         * 插件奖品信息
         */
        get: function () {
            return this._optionInfoData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "unblockingData", {
        /**
         * 解锁插件
         */
        get: function () {
            return this._unblockingData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "datapashData", {
        /**
         * 防作弊阶段提交
         */
        get: function () {
            return this._datapashData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "summerBuyPropData", {
        get: function () {
            return this._summerBuyPropData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "summerOrderStatus", {
        get: function () {
            return this._summerOrderStatus;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "summerToyInfo", {
        get: function () {
            return this._summerToyInfo;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "petHomeInfoData", {
        /**
         * 养成
         * 宠物基础数据
         */
        get: function () {
            return this._petHomeInfoData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "petAdopteData", {
        /**
         * 取名字界面数据
         */
        get: function () {
            return this._petAdopteData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "petFeedData", {
        /**
         * 养成
         * 宠物喂食回调数据
         */
        get: function () {
            return this._petFeedData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "signInfoData", {
        /**
         * 养成
         * 签到信息
         */
        get: function () {
            return this._signInfoData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "getSignResultData", {
        /**
         * 养成
         * 签到结果轮询信息
         */
        get: function () {
            return this._getSignResultData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "petStatusData", {
        /**
         * 养成
         * 刷新宠物状态
         */
        get: function () {
            return this._petStatusData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "getPrizeInfoList", {
        /**
         * 插件列表
         */
        get: function () {
            return this._getPrizeInfoList;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "getRankListData", {
        /**
         * 喂养排名信息
         */
        get: function () {
            return this._getRankListData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "getFoodPilesData", {
        /**
         * 查询待领取粮食信息
         */
        get: function () {
            return this._getFoodPilesData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "toyExchangesDataXC", {
        /**
         * 购买道具携程(积分购买)
         */
        get: function () {
            return this._toyExchangesDataXC;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "getRecordData", {
        /**
         * 查询我的奖品记录
         */
        get: function () {
            return this._getRecordData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "getHomeInfoData", {
        /**
         * 外来宠物养成--活动主信息接口
         */
        get: function () {
            return this._getHomeInfoData;
        },
        set: function (d) {
            this._getHomeInfoData = d;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "gtBatchollectFoodData", {
        /**
         * 收取猫草回调数据
         */
        get: function () {
            return this._batchollectFoodData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "getActToysListData", {
        /**
         * 外来宠物养成--商店道具列表
         * _getActToysListData是个object，根据类型归类存放数据
         * _getActToysListData[type] = GetActToysListData
         * type: 1食物，2道具，3...
         */
        get: function () {
            return this._getActToysListData;
        },
        set: function (d) {
            this._getActToysListData = d;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "getUserToysListData", {
        /**
         * 外来宠物养成--我的道具列表
         */
        get: function () {
            return this._getUserToysListData;
        },
        set: function (d) {
            this._getUserToysListData = d;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "visitStatisticsData", {
        /**
         * 外来宠物养成--来访统计
         */
        get: function () {
            return this._visitStatisticsData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "getVisitInfoData", {
        /**
         * 外来宠物养成--动态信息列表
         */
        get: function () {
            return this._getVisitInfoData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "visitDetailData", {
        /**
         * 外来宠物养成--到访记录详情
         */
        get: function () {
            return this._visitDetailData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "collectGiftRecord", {
        /**
         * 外来宠物养成--礼物收取
         */
        get: function () {
            return this._collectGiftRecord;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "gooutData", {
        // /**
        //  * 订制接口-收入明细
        //  */
        // public get getProfitDetailData():GetProfitDetailData{
        //     return this._getProfitDetailData;
        // }
        /**
         * 订制接口-携程宠物出行
         */
        get: function () {
            return this._gooutData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "gooutResultData", {
        /**
         * 订制接口-携程宠物出行结果
         */
        get: function () {
            return this._gooutResultData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "gooutRewardData", {
        /**
         * 订制接口-携程宠物出行奖励
         */
        get: function () {
            return this._gooutRewardData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "weOrderData", {
        /**
         * 订制接口-获取用户积分流水明细
         */
        get: function () {
            return this._weOrderData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataManager.prototype, "shopYunjiData", {
        // tslint:disable-next-line:max-file-line-count
        /**
         * 商店数据云集
         */
        get: function () {
            return this._shopYunjiData;
        },
        enumerable: true,
        configurable: true
    });
    return DataManager;
}(ABDataManager));
export { DataManager };
