var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
import { Data } from "../Data";
var PetHomeInfoData = /** @class */ (function (_super) {
    __extends(PetHomeInfoData, _super);
    function PetHomeInfoData() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        /**
         * 当前状态（1:正常 2:外出 3:吃饭 4:学习 5:喝水 6:睡觉）
         */
        _this.status = 0;
        /**
         * 状态过期倒计时（单位：分钟，目前只针对吃饭状态有此值）
         */
        _this.leftMinutes = 0;
        /**
         * 宠物名称
         */
        _this.petName = "";
        /**
         * 宠物等级
         */
        _this.petLevel = 0;
        /**
         * 饲养员拥有食物量
         */
        _this.foodNum = 0;
        /**
         * 食物名称
         */
        _this.foodName = "";
        /**
         * 每次喂养食物数量
         */
        _this.feedLimit = 10;
        /**
         * 宝箱插件id
         */
        _this.awardPluginId = 0;
        /**
         * 外出奖励（-1:自定义奖励 0:无奖励 1：粮食奖励）
         */
        _this.travelRewardType = 0;
        /**
         * 外出奖励个数(针对粮食奖励)
         */
        _this.travelRewardNum = 0;
        /**
         * 宠物正在使用的道具数据
         */
        _this.toy = [];
        /**
         * 当前经验值
         */
        _this.petExp = 0;
        /**
         * 当前级别初始的经验值
         */
        _this.currentLevelExp = 0;
        /**
         * 下个级别初始的经验值
         */
        _this.nextLevelExp = 0;
        /**
         * 粮食存储上限
         */
        _this.foodStoreLimit = 0;
        /**
         * 当前状态总持续时间
         */
        _this.statusTotalTime = 0;
        /**
         * 当前状态剩余时间，单位秒
         */
        _this.statusRemainingTime = 0;
        return _this;
    }
    PetHomeInfoData.prototype.update = function (result) {
        if (!result) {
            return;
        }
        _super.prototype.update.call(this, result);
        var result2;
        if (result.data) {
            result2 = result.data;
        }
        if (result2) {
            if (result2.petId) {
                this.petId = result2.petId;
            }
            if (result2.status) {
                this.status = result2.status;
            }
            if (result2.leftMinutes) {
                this.leftMinutes = result2.leftMinutes;
            }
            if (result2.isFull) {
                this.isFull = result2.isFull;
            }
            if (result2.petName) {
                this.petName = result2.petName;
            }
            if (result2.petLevel) {
                this.petLevel = result2.petLevel;
            }
            if (result2.foodNum || result2.foodNum == 0) {
                this.foodNum = result2.foodNum;
            }
            if (result2.foodName) {
                this.foodName = result2.foodName;
            }
            if (result2.feedLimit) {
                this.feedLimit = result2.feedLimit;
            }
            if (result2.awardPluginId) {
                this.awardPluginId = result2.awardPluginId;
            }
            if (result2.travelRewardType) {
                this.travelRewardType = result2.travelRewardType;
            }
            if (result2.travelRewardNum) {
                this.travelRewardNum = result2.travelRewardNum;
            }
            this.toy = result2.toy;
            if (result2.levelRewardPluginId) {
                this.levelRewardPluginId = result2.levelRewardPluginId;
            }
            if (result2.petExp) {
                this.petExp = result2.petExp;
            }
            if (result2.currentLevelExp) {
                this.currentLevelExp = result2.currentLevelExp;
            }
            if (result2.nextLevelExp) {
                this.nextLevelExp = result2.nextLevelExp;
            }
            if (result2.foodStoreLimit) {
                this.foodStoreLimit = result2.foodStoreLimit;
            }
            if (result2.statusTotalTime) {
                this.statusTotalTime = result2.statusTotalTime;
            }
            if (result2.statusRemainingTime) {
                this.statusRemainingTime = result2.statusRemainingTime + 5; //增加5秒确保服务端时间到期
            }
            if (result2.foodList) {
                this.foodList = result2.foodList;
            }
            if (result2.foodPileList) {
                this.foodPileList = result2.foodPileList;
            }
        }
    };
    return PetHomeInfoData;
}(Data));
export { PetHomeInfoData };
