import { GFun } from './GFun';
import { GConsole } from './GConsole';
var GCache = /** @class */ (function () {
    function GCache() {
    }
    /**
     * 初始化
     * @param keys
     */
    GCache.init = function (keys) {
        var i = 0;
        var len = keys.length;
        this.gKey = '';
        for (i; i < len; i++) {
            this.gKey += '_' + keys[i];
        }
    };
    /**
     * 写入缓存
     * @param key
     * @param value
     * @param type type 缓存类型 localStorage永久缓存 sessionStorage浏览器生命周期结束前'
     */
    GCache.writeCache = function (key, value, type) {
        if (type === void 0) { type = 'localStorage'; }
        if (!window[type]) {
            GConsole.log(GFun.replace('webview不支持{0}', [type]));
            return;
        }
        window[type].setItem(key + this.gKey, value);
    };
    /**
     * 读取缓存
     * @param key
     * @param type type 缓存类型 localStorage永久缓存 sessionStorage浏览器生命周期结束前'
     * @return
     */
    GCache.readCache = function (key, type) {
        if (type === void 0) { type = 'localStorage'; }
        if (!window[type]) {
            GConsole.log(GFun.replace('webview不支持{0}', [type]));
            return;
        }
        return window[type].getItem(key + this.gKey);
    };
    /**
     * 删除缓存
     * @param key
     * @param type 缓存类型 localStorage永久缓存 sessionStorage浏览器生命周期结束前
     */
    GCache.removeCache = function (key, type) {
        if (type === void 0) { type = 'localStorage'; }
        if (!window[type]) {
            GConsole.log(GFun.replace('webview不支持{0}', [type]));
            return;
        }
        window[type].removeItem(key + this.gKey);
    };
    return GCache;
}());
export { GCache };
