"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
var Panel_1 = require("../views/Panel");
var AlbumItem_1 = require("./AlbumItem");
var DataManager_1 = require("../../libs/tw/manager/DataManager");
var panelCtrl_1 = require("../ctrls/panelCtrl");
var sceneTypes_1 = require("../types/sceneTypes");
/**
 * 相册界面
 */
var AlbumPanel = (function (_super) {
    __extends(AlbumPanel, _super);
    function AlbumPanel() {
        var _this = _super.call(this) || this;
        _this.init();
        return _this;
    }
    Object.defineProperty(AlbumPanel.prototype, "skinKey", {
        get: function () { return 'Album'; },
        enumerable: true,
        configurable: true
    });
    AlbumPanel.prototype.start = function (data) {
        this.percentHeight = 100;
        this.guideBack = data;
    };
    AlbumPanel.prototype.init = function () {
        this.itemList = [];
        var rule = DataManager_1.DataManager.ins.getCollectRuleData.collectRules[0].rule;
        var i = 0;
        for (var _i = 0, rule_1 = rule; _i < rule_1.length; _i++) {
            var obj = rule_1[_i];
            if (obj.count > 0) {
                this.itemList[i] = new AlbumItem_1.default();
                this.con.addChild(this.itemList[i]);
                this.itemList[i].updateData(obj, i);
                this.itemList[i].addEventListener(egret.TouchEvent.TOUCH_TAP, this.openInfo, this);
                i++;
            }
        }
        this.con.width = 650;
        this.con.height = 910;
        this.con.x = 50;
        this.con.bottom = 55;
        this.scroller = new eui.Scroller();
        this.scroller.viewport = this.con;
        this.addChild(this.scroller);
        this.scroller.x = 50;
        this.scroller.bottom = 55;
    };
    //打开相片
    AlbumPanel.prototype.openInfo = function (e) {
        var d = e.currentTarget.data;
        var infoList = DataManager_1.DataManager.ins.getCollectGoodsInfoData;
        var infoData = infoList.getCollectInfoByID(d.id);
        console.log('查看' + infoData.name + '详情');
        panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.ALBUM_INFO_PANEL, infoData);
    };
    AlbumPanel.prototype.initEvents = function () {
        this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_hidePanel, this);
    };
    AlbumPanel.prototype.removeEvents = function () {
        this.closeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_hidePanel, this);
        for (var i = 0; i < this.itemList.length; i++) {
            this.itemList[i].removeEventListener(egret.TouchEvent.TOUCH_TAP, this.openInfo, this);
            this.con.removeChild(this.itemList[i]);
        }
    };
    AlbumPanel.prototype.onClick_hidePanel = function () {
        _super.prototype.hidePanel.call(this);
        if (this.guideBack) {
            this.guideBack(10);
        }
    };
    return AlbumPanel;
}(Panel_1.default));
exports.default = AlbumPanel;
__reflect(AlbumPanel.prototype, "\"/Users/chiwang/Desktop/\u5151\u5427\u5DE5\u4F5C/gameegret20181011/db-game-template/egret/src/albumPanel/AlbumPanel\".AlbumPanel");
//# sourceMappingURL=AlbumPanel.js.map