import Panel from "../../MVC/views/Panel";
import { HtmlTextParser } from "../../../libs/tc/util/HtmlTextParser";
import { NetManager } from "../../../libs/tw/manager/NetManager";
import { DataManager } from "../../../libs/tw/manager/DataManager";

export default class RulePanel extends Panel {
    public group: eui.Group;
    public closeBtn: eui.Button;
    public ruleLabel: eui.Label;

    public get skinKey() {
        return 'RulePanel'
    }

    public get groupName() {
        return 'prize_panel'
    }

    constructor(data?) {
        super(data);

    }

    initEvents() {
        this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this);
    }

    removeEvents() {
        this.closeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this);
    }

    protected onSkinComplete(): void {
        super.onSkinComplete();

        this.preLoadRes();
        this.onLoad();

    }

    protected onLoad(): void {
        this.initUI();
    }

    private initUI(): void {
        let rule = DataManager.ins.ajaxElementData.rule;
        this.ruleLabel.textFlow = new HtmlTextParser().parse(rule);
        let _y = this.group.y;
		this.group.y = _y - 300;
        egret.Tween.get(this.group).to({y: _y}, 800, egret.Ease.bounceOut);
    }

    protected async preLoadRes() {

        return new Promise(function(resolve, reject) {
            resolve();
        });
    }
}