import Panel from "../../MVC/views/Panel";
import { DataManager } from "../../../libs/tw/manager/DataManager";
import { NetName } from "../../../libs/tw/enum/NetName";
import { PrizeTypes } from "../../Scene/StartScene/RotaryData";
import { NetManager } from "../../../libs/tw/manager/NetManager";
import { GDispatcher } from "../../../libs/tc/util/GDispatcher";

export default class PrizePanel extends Panel {
	public group: eui.Group;
	public closeBtn: eui.Button;
	public prizeImg: eui.Image;
	public prizeName: eui.Label;
	public ok_btn: eui.Button;

	public get skinKey() { return 'PrizePanel' }
	public get groupName() { return 'prize_panel' }

	constructor(data?) {
		super(data);

	}
	initEvents() {
		this.ok_btn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.touch_tap_ok_btn, this);
		this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this);
	}

	onTouchTap(){
		GDispatcher.dispatchEvent('getCount');
		GDispatcher.dispatchEvent('panelEffect');
		super.onTouchTap();
	}

	touch_tap_ok_btn() {
		window.location.href = this.data.link;
	}

	removeEvents() {
		this.ok_btn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.touch_tap_ok_btn, this);
		this.closeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this);
	}



	protected onSkinComplete(): void {
		super.onSkinComplete();

		this.preLoadRes();
		this.onLoad();

	}

	protected onLoad(): void {
		this.initUI();
		// this.url = this.data;
	}

	private initUI(): void {
		// let data = DataManager.ins.getData(NetName.QUERY_PRIZE_INFO).data;
		this.prizeImg.source = this.data.imgUrl;
		this.prizeName.text = this.data.title;
		let _y = this.group.y;
		this.group.y = _y - 300;
		egret.Tween.get(this.group).to({y: _y}, 800, egret.Ease.bounceOut);
	}

	protected async preLoadRes() {

		return new Promise(function (resolve, reject) {
			resolve();
		});
	}
}