import Panel from "../../MVC/views/Panel";
import { NetManager } from '../../../libs/tw/manager/NetManager';
import TopLayerCtrl from '../../MVC/ctrls/topLayerCtrl';
import { ModuleTypes } from '../../Comm/types/sceneTypes';
import PanelCtrl from '../../MVC/ctrls/panelCtrl';
import getItem = egret.localStorage.getItem;
import { getlogItem } from "../../getlogItem";
import { GDispatcher } from "../../../libs/tc/util/GDispatcher";

export default class PhonePanel extends Panel {

    public get skinKey() {
        return "PhonePanel"
    }

    public get groupName() {
        return "phone_panel"
    }

    public group: eui.Group;
    public submitBtn: eui.Button;
    public inputGroup: eui.Group;

    myEditableText: eui.EditableText = new eui.EditableText();

    constructor(data) {
        super(data);
    }


    initEvents() {
        super.initEvents();
        this.submitBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_Submit, this);
    }

    onSkinComplete() {
        super.onSkinComplete();
        this.initInput();
        let _y = this.group.y;
        this.group.y = _y - 300;
        egret.Tween.get(this.group).to({y: _y}, 800, egret.Ease.bounceOut);
        NetManager.ins.showLog(getlogItem(4));
    }

    initInput() {
        this.myEditableText.text = "";
        //指定文本的颜色。
        this.myEditableText.textColor = 0x999595;
        //指定我们的文本输入框的宽和高
        this.myEditableText.width = this.inputGroup.width;
        this.myEditableText.height = this.inputGroup.height;
        this.myEditableText.x = 0;
        this.myEditableText.y = 0;
        this.myEditableText.size = 32;
        this.myEditableText.lineSpacing = 68;
        this.myEditableText.textAlign = "center";
        this.myEditableText.verticalAlign = "middle";
        this.myEditableText.maxChars = 11;
        this.myEditableText.prompt = "请输入您的手机号";
        this.inputGroup.addChild(this.myEditableText);
    }

    onTap_Submit() {
        NetManager.ins.clickLog(getlogItem(4));
        PanelCtrl.instance.btnDelay(this.submitBtn);
        if(!(/^1(3|4|5|6|7|8|9)\d{9}$/.test(this.myEditableText.text))) {
            TopLayerCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg: "请输入正确手机号"});
            return;
        }
        NetManager.ins.submitPhone((success) => {
            if(!success) {
                TopLayerCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg: "手机提交失败"});
                return;
            }
            NetManager.ins.getPhone(() => {
                if(!success) {
                    return
                }
            });  // 更新存储的手机号
            TopLayerCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg: "提交成功"});
            PanelCtrl.instance.show(ModuleTypes.PRIZE_PANEL, this.data);
        }, this.myEditableText.text);
    }

    removeEvents() {
        super.removeEvents();
        this.submitBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_Submit, this);
    }
}