import Panel from "../../MVC/views/Panel";
import { GDispatcher } from "../../../libs/tc/util/GDispatcher";

export default class NoTimesPanel extends Panel {
	public group: eui.Group;
	public ok_btn: eui.Button;
	public closeBtn: eui.Button;

	public get skinKey() { return 'NoTimesPanel' }
	public get groupName() { return 'noTimes_panel' }
	constructor(data?) {
		super(data);
	}
	initEvents() {
		this.ok_btn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this);
		this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this);
	}

	removeEvents() {
		this.ok_btn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this);
		this.closeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this);
	}

	protected onSkinComplete(): void {
		super.onSkinComplete();

		this.preLoadRes();
		let _y = this.group.y;
		this.group.y = _y - 300;
		egret.Tween.get(this.group).to({y: _y}, 800, egret.Ease.bounceOut);
	}

	protected async preLoadRes() {


		return new Promise(function (resolve, reject) {
			resolve();
		});
	}
}