/**
 * 特效管理器
 */
export default class EffectMgr {

    // 单例
    static _instance;
    static get instance() {
        return EffectMgr._instance || (EffectMgr._instance = new EffectMgr())
    }

    constructor() {

    }

    /**
     * 呼吸效果
     * @param obj - 要呼吸的对象
     */
    public breathingEffect(obj: any) {
        egret.Tween.get(obj).to({scaleX: 0.92, scaleY: 0.92}, 500, egret.Ease.sineInOut).call(
            () => {
                egret.Tween.get(obj).to({scaleX: 1, scaleY: 1}, 500, egret.Ease.sineInOut).call(
                    () => {
                        this.breathingEffect(obj);
                    });
            }
        );
    }

    /**
     * 添加弹跳效果
     * @param obj
     * @param height - 高度
     * @param rotation - 旋转角度
     * @param duration - 时间
     * @param wait - 跳动结束等待时间
     * @param call - 回调函数
     */
    public jumpOnce(obj: any, height: number, rotation: number, duration: number, wait: number, call: Function) {
        let _y = obj.y - height;
        egret.Tween.get(obj).to({rotation: rotation, y: _y}, duration, egret.Ease.sineInOut).call(
            () => {
                egret.Tween.get(obj).to({
                    rotation: 0,
                    y: _y + height
                }, duration, egret.Ease.sineInOut).wait(wait).call(() => {
                    if(call) {
                        call();
                    }
                });
            }
        );
    }

    /**
     * 永远旋转
     * @param obj - 要旋转的对象
     * @param duration - 一圈的时间
     */
    public rotationForever(obj: any, duration: number = 1000) {
        egret.Tween.get(obj).to({rotation: 360}, duration).call(
            () => {
                this.rotationForever(obj, duration);
            }
        );
    }

    /**
     * 心跳效果
     * @param obj
     * @param max - 最大的缩放值
     * @param min - 最小的缩放值
     * @param duration - 一次心跳的时间
     * @param wait - 一次心跳等待的时间
     */
    public heartbeatEffect(obj: any, max: number, min: number, duration: number = 1000, wait: number = 500) {
        if(obj['canOpen'] == false){
            return;
        }
        egret.Tween.get(obj).to({scaleX: max, scaleY: max}, duration / 2, egret.Ease.sineIn).call(
            () => {
                egret.Tween.get(obj).to({scaleX: min, scaleY: min}, duration / 2, egret.Ease.sineOut).wait(wait).call(
                    () => {
                        this.heartbeatEffect(obj, max, min, duration, wait);
                    }
                );
            }
        );
    }

    /**
     * 快速缓动透明度
     * @param obj
     * @param alpha - 透明度
     * @param duration - 时间
     * @param call - 回调函数
     */
    public easyAlpha(obj: any, alpha: number, duration: number = 500, call?: Function) {
        egret.Tween.get(obj).to({
            alpha: alpha,
        }, duration, egret.Ease.sineInOut).call(() => {
            if(call) {
                call();
            }
        });
    }

    /**
     * 快速缩放
     * @param obj
     * @param scale - 正比缩放值，若scaleY存在则是X缩放值
     * @param scaleY - Y缩放值
     * @param duration - 时间
     * @param call - 回调函数
     */
    public easySacleXY(obj: any, scale: number, scaleY?: number, duration: number = 500, call?: Function) {
        egret.Tween.get(obj).to({
            scaleX: scale,
            scaleY: scaleY || scale
        }, duration || 500, egret.Ease.sineInOut).call(() => {
            if(call) {
                call();
            }
        });
    }

    public addScaleOut(obj: any) {
        obj.scaleX = 0;
        obj.scaleY = 0;
        egret.Tween.get(obj).to({scaleX: 1, scaleY: 1}, 300, egret.Ease.sineIn);
    }
}
