import { a } from "../../../libs/tc/index";

export default class AudioCtrl {
    // static _instance: AudioCtrl;
    // static get instance() {
    //     return this._instance || (this._instance = new AudioCtrl());
    // }

    private static audios = {};
    private static bg: egret.Sound;

    /**
     * 切换背景音乐
     * @param bg 背景音乐
     */
    public static changeBgMusic(bg: egret.Sound) {
        if(this.bg) {
            this.bg.close();
        }
        setTimeout(() => {
            if(bg) {
                this.bg = bg;
                this.bg.play();
            }
        }, 50);
    }

    /**
     * 恢复当前背景音乐
     */
    public static resumeBgMusic() {
        if(this.bg) {
            this.bg.play();
        }
    }

    /**
     * 停止背景音乐
     */
    public static stopBgMusic() {
        if(this.bg) {
            this.bg.close();
        }
    }

    /**
     * 添加音频
     * @param name 音频的名字
     * @param audio 音频
     */
    public static addAudio(name: string, audio: egret.Sound) {
        if(!this.audios[name]) {
            this.audios[name] = audio;
        }
    }

    /**
     * 播放音频
     * @param name 音频的名字
     * @param playTimes 播放次数，默认值是 1，循环播放。 大于 0 为播放次数，如 1 为播放 1 次；小于等于 0，为循环播放。
     * @param startTime 应开始播放的初始位置（以秒为单位），默认值是 0
     */
    public static playAudio(name: string, playTimes: number = 1, startTime: number = 0) {
        if(!this.audios[name]) {
            return;
        }
        this.audios[name].play(startTime, playTimes);

    }

    /**
     * 停止音频
     * @param name 音频的名字
     */
    public static stopAudio(name: string) {
        if(this.audios[name]) {
            this.audios[name].close();
        }
    }

    /**
     * 删除音频
     * @param name - 音频的名字
     */
    public static delAudio(name: string) {
        if(this.audios[name]) {
            delete this.audios[name];
        }
    }

    /**
     * 清空音频
     */
    public static clearAudio() {
        for(let v in this.audios) {
            delete this.audios[v];
        }
    }

}