import { getSkinPath } from "../../utils";

export default class ComponentBase extends eui.Component {
    protected data: any;
    constructor(data?) {
        super();

        this.data = data;
        this.start(data);
        
        // if (!window['development'] && this.groupName) {
        //     RES.getResByUrl(`${this.groupName}_json`, (sheet: egret.SpriteSheet) => {
        //         console.log('界面大图加载完');
        //         this.setSkinName();
        //     }, this, RES.ResourceItem.TYPE_SHEET);
        // }else{
        //     this.setSkinName();
        // }

        this.initComponet();
    }

    private async initComponet(){
        await this.preLoadRes();
        console.log('执行了if (!window && this.groupName) {');
        if (!window['development'] && this.groupName) {
            RES.getResByUrl(`${this.groupName}_json`, (sheet: egret.SpriteSheet) => {
                console.log('界面大图加载完');
                this.setSkinName();
            }, this, RES.ResourceItem.TYPE_SHEET);
        }else{
            this.setSkinName();
        }
    }

    /**
     * 是否有要提前加载的资源
     */
    protected async preLoadRes(){
        return new Promise(function(resolve, reject){
            resolve();
        });
    }

    protected initEvents() { }

    protected removeEvents() { }

    start(data?) {

    }

    //设置皮肤
    public setSkinName():void{
        console.log('this.skinKey=' + this.skinKey);
        this.addEventListener(egret.Event.COMPLETE, this.onSkinComplete, this);
        this.skinName = getSkinPath(this.skinKey);

        // if (this.skin) {
        //     console.log('已经有了this.skin');
        //     this.onSkinComplete();
        // }
    }

    public get skinKey() { return null }

    //获取资源组名字
    public get groupName() { return null }

    protected onSkinComplete() {

        console.log('皮肤加载完成');
        // Loading.instace.hide();
        this.initEvents();
    }

    destroy() {
        this.removeEvents();
    }
    
}