"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
var Panel_1 = require("../views/Panel");
var panelCtrl_1 = require("../ctrls/panelCtrl");
var sceneTypes_1 = require("../types/sceneTypes");
var DataManager_1 = require("../../libs/tw/manager/DataManager");
var Buried_1 = require("../../libs/tw/util/Buried");
var NetManager_1 = require("../../libs/tw/manager/NetManager");
/**
 * 赚金币界面
 */
var EarnGoldCoinPanel = (function (_super) {
    __extends(EarnGoldCoinPanel, _super);
    function EarnGoldCoinPanel() {
        var _this = _super.call(this) || this;
        _this.init();
        return _this;
    }
    Object.defineProperty(EarnGoldCoinPanel.prototype, "skinKey", {
        get: function () { return 'EarnGoldCoin'; },
        enumerable: true,
        configurable: true
    });
    EarnGoldCoinPanel.prototype.init = function () {
        this.updateData();
    };
    EarnGoldCoinPanel.prototype.start = function () {
        this.percentHeight = 100;
    };
    EarnGoldCoinPanel.prototype.updateData = function () {
        this.shareBtn['txt'].text = '每分享1位好友，可随机获得金币';
        this.sginBtn['txt1'].text = '已连续登陆' + DataManager_1.DataManager.ins.signInfoData.signInfoVO.continueDay + '天';
        this.sginBtn['txt2'].text = '累计签到一周可获得310金币';
    };
    /**
     * 分享
     */
    EarnGoldCoinPanel.prototype.onClick_shareBtn = function () {
        console.log('分享');
        panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.SHARE_PANEL);
        //点击埋点，分享
        var dpm = Buried_1.Buried.connectDpm(110, 8, 1);
        var dcm = Buried_1.Buried.connectDcm(230, window['skinID'], 0);
        var embedDomain = DataManager_1.DataManager.ins.petIndexData.embedDomain;
        var exposure = Buried_1.Buried.createExposure(dpm, dcm, embedDomain);
        NetManager_1.NetManager.ins.clickLog(exposure);
    };
    /**
     * 签到
     */
    EarnGoldCoinPanel.prototype.onClick_sginBtn = function () {
        console.log('签到');
        this.hidePanel();
        panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.SIGN_IN_PANEL);
        //点击埋点，跳转签到按钮
        var dpm = Buried_1.Buried.connectDpm(110, 8, 2);
        var dcm = Buried_1.Buried.connectDcm(230, window['skinID'], 0);
        var embedDomain = DataManager_1.DataManager.ins.petIndexData.embedDomain;
        var exposure = Buried_1.Buried.createExposure(dpm, dcm, embedDomain);
        NetManager_1.NetManager.ins.clickLog(exposure);
    };
    EarnGoldCoinPanel.prototype.initEvents = function () {
        this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.hidePanel, this);
        this.shareBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_shareBtn, this);
        this.sginBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_sginBtn, this);
    };
    EarnGoldCoinPanel.prototype.removeEvents = function () {
        this.closeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.hidePanel, this);
        this.shareBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_shareBtn, this);
        this.sginBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_sginBtn, this);
    };
    return EarnGoldCoinPanel;
}(Panel_1.default));
exports.default = EarnGoldCoinPanel;
__reflect(EarnGoldCoinPanel.prototype, "\"/Users/chiwang/Desktop/\u5151\u5427\u5DE5\u4F5C/gameegret20181011/db-game-template/egret/src/earnGoldCoinPanel/EarnGoldCoinPanel\".EarnGoldCoinPanel");
//# sourceMappingURL=EarnGoldCoinPanel.js.map