import Scene from "../views/Scene";
import { ModuleTypes } from "../types/sceneTypes";
import TopLayerCtrl from "../ctrls/topLayerCtrl";
import PanelCtrl from "../ctrls/panelCtrl";


export default class IndexScene extends Scene {
    public panel: eui.Image;
    public start_btn: eui.Button;
    public act_btn: eui.Button;
    public myPrize_btn: eui.Button;
    public tips_label: eui.Label;

    public get skinKey() {
        return 'IndexScene'
    }

    public get groupName() {
        return 'index'
    }

    constructor(data?) {
        super(data);
    }

    initEvents() {

    }

    private showToast(msg) {
        TopLayerCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg: msg});
    }

    removeEvents() {

    }

    protected onSkinComplete(): void {
        super.onSkinComplete();
        this.onLoad();

    }

    protected onLoad(): void {
        this.initUI();
    }


    private initUI(): void {
        PanelCtrl.instance.show(ModuleTypes.TURNTABLE_PANEL);
    }

    protected async preLoadRes() {

        return new Promise(function (resolve, reject) {
            resolve();
        });
    }
}