import { ModuleTypes } from "../../types/sceneTypes";
import TopLayerCtrl from "../../ctrls/topLayerCtrl";
import Panel from "../../views/Panel";

export default class TurnTablePanel extends Panel {
    public closeBtn: eui.Button;
    public selectRect: eui.Rect;
    public startBtn: eui.Button;

    private totalTimes: number = 0;      // 转盘需要旋转总次数
    private selectTimes: number = 0;    // 当前已经旋转次数
    private selectIndex: number = 0;     // 当前选中奖品index

    constructor(data?) {
        super(data);
    }

    initEvents() {
        this.startBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap_start, this);
        this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this);
    }

    removeEvents() {
        this.startBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap_start, this);
        this.closeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this);
    }

    onTouchTap_start() {
        this.setBtnTouch(false);
        this.rota(2400);    // 开始旋转，设置一个很大的值 期间等待接口返回成功后改变这个值
        this.getPrize();          // 抽奖
    }

    /**
     * 开始旋转
     * @param times - 总共要旋转的次数
     */
    private rota(times) {
        this.totalTimes = times;    // 设置总共要旋转的次数
        this.selectPrize();         // 转盘选择奖品
    }

    // 设置全部按钮是否可以点击
    private setBtnTouch(touchEnabled: boolean) {
        this.startBtn.touchEnabled = touchEnabled;
        this.closeBtn.touchEnabled = touchEnabled;
    }

    // 转盘选择奖品
    private selectPrize() {
        function setWait(wait, dt, that) {  // 设置等待时间
            if(dt < 8) wait += that.Random(150, 250);
            if(dt < 4) wait += that.Random(150, 250);
            if(dt < 2) wait += that.Random(150, 250);
            // if(dt < 1) wait += that.Random(150, 250);
            return wait;
        }

        let dt = this.totalTimes - ++this.selectTimes;  // 差值
        if(dt < 0) {   // 次数到了就结束
            this.selectTimes = this.selectIndex;    // 当前旋转次数等于当前选择的奖品index（防止直接进行下次旋转时出错）
            setTimeout(() => {
                this.setBtnTouch(true);
                //////////////////////////////// 旋转结束弹窗 ////////////////////////////////

            }, 100);
            return;
        }

        // 计算等待时间，次数越多越慢的效果，传入一个标准时间，一个剩下需要旋转的次数和当前的Context
        let wait = setWait(100, dt, this);

        // 设置阴影位置
        let index = this.selectIndex = (++this.selectIndex > 7) ? 0 : this.selectIndex; // index
        this.selectRect.x = this[`prizeGroup${index}`].x;
        this.selectRect.y = this[`prizeGroup${index}`].y;

        // 等待并递归
        setTimeout(() => {
            this.selectPrize(); // 递归
        }, wait);
    }

    /**
     * 抽奖
     */
    private getPrize() {
        new Promise((resolve, reject) => {
            //////////////////////// 调用接口 ////////////////////////
            setTimeout(() => resolve("接口成功的数据"), 1000);  // 模拟接口成功

        }).then(
            (res) => {  // 接口成功
                console.log(res);
                // 改变一下要旋转总次数 当前旋转次数整除转盘个数 + 1 * 转盘个数 + 数倍的转盘个数 + 奖品所在的转盘index
                this.totalTimes = (~~(this.selectTimes / 8) + 1) * 8 + 16 + 3;
            },
            (err) => {  // 接口失败

            }
        );
    }

    /**
     * 查询奖品的信息
     */
    private queryPrizeInfo() {
        /////////////////////// 查询奖品信息 并设置大转盘图片文字 并设置RotaryData ///////////////////////

    }

    private showToast(msg) {
        TopLayerCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg: msg});
    }

    protected onSkinComplete(): void {
        super.onSkinComplete();
        this.onLoad();

    }

    protected onLoad(): void {
        this.initUI();
    }

    private initUI(): void {
        this.queryPrizeInfo();
    }

    /**
     * 产生一个固定范围的随机数(左闭右开)
     * @param start
     * @param end
     */
    private Random(start: number, end: number) {
        return Math.random() * (end - start) + start;
    }

    /**
     * 产生一个固定范围的随机整数(左闭右开)
     * @param start
     * @param end
     */
    private RandomInt(start: number, end: number) {
        return Math.floor(Math.random() * (end - start) + start);
    }

    protected async preLoadRes() {

    }

    public get skinKey() {
        return 'TurnTablePanel'
    }

    public get groupName() {
        return 'turnTable_panel'
    }
}