import Panel from "../../views/Panel";
import { HtmlTextParser } from "../../../libs/tc/util/HtmlTextParser";

export default class RulePanel extends Panel {
	public closeBtn: eui.Button;
	public ruleLabel: eui.Label;

	public get skinKey() { return 'RulePanel' }
	public get groupName() { return 'prize_panel' }
	constructor(data?) {
		super(data);

	}
	initEvents() {
		this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this);
	}

	removeEvents() {
		this.closeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this);
	}

	protected onSkinComplete(): void {
		super.onSkinComplete();

		this.preLoadRes();
		this.onLoad();
		
	}

	protected onLoad(): void {
		this.initUI();
	}

	private initUI(): void {
		this.ruleLabel.textFlow = new HtmlTextParser().parse(window['rule']);
	}

	protected async preLoadRes() {

		return new Promise(function (resolve, reject) {
			resolve();
		});
	}
}