import Loading from "../loading/Loading";
import ComponentBase from "../components/ComponentBase";

export default class Panel extends ComponentBase {
    constructor(data?) {
        super(data);
    }

    protected getTapEvts(): any[] {
        return super.getTapEvts();
    }

    protected getBeginEvts(): any[] {
        return super.getBeginEvts();
    }

    initEvents() {
        super.initEvents();
        if(this.closeBtns && this.closeBtns.length > 0){
            this.closeBtns.forEach(
                btn => { if(btn) btn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchClose, this) }
            )
        }
    }
    removeEvents() {
        super.removeEvents();
        if(this.closeBtns && this.closeBtns.length > 0){
            this.closeBtns.forEach(
                btn => { if(btn) btn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchClose, this) }
            )
        }
    }

    protected onSkinComplete() {
        super.onSkinComplete();
        Loading.instace.hide();
    }

    protected get closeBtns(): eui.Button[] { return [this['closeBtn']] }
    protected get confirmBtns(): eui.Button[] { return [this['confirmBtn']]}
    protected get creditsOutBtns(): eui.Button[] { return [this['creditsOutBtn']] }

    onTouchClose(): any {
        this.hidePanel();
    }

    hidePanel() {
        this.destroy();
        this.dispatchEvent(new egret.Event('onDestroy'));
    }
}