import Scene from "../views/Scene";
import { ModuleTypes } from "../types/sceneTypes";
import PanelCtrl from "../ctrls/panelCtrl";
import { gotoRecord, showToast } from "../comm/UtilsConst";
import SceneCtrl from "../ctrls/sceneCtrl";
import { NetManager } from "../../libs/tw/manager/NetManager";
import CutTimer from "../comm/CutTimer";
import Utils from "../comm/Utils";
import { getlogItem } from "../getlogItem";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetName } from "../../libs/tw/enum/NetName";
import { HtmlTextParser } from "../../libs/tc/util/HtmlTextParser";

export default class IndexScene extends Scene {
    public scroller:eui.Scroller;
    public rule_btn:eui.Image;
    public myprize_btn:eui.Image;
    public tips_img:eui.Image;
    public cutLabel:eui.BitmapLabel;
    public tipsLabel:eui.Label;
    public btn:eui.Image;
    public shareBtn:eui.Image;
    public hbLabel:eui.Label;


    private cutTimer: CutTimer = null;

    documentEvent: Function = () => {
    };

    public get skinKey() {
        return 'IndexScene'
    }

    public get groupName() {
        return 'index_scene'
    }

    constructor(data?) {
        super(data);
    }

    protected getTapEvts(): any[] {
        super.getTapEvts();
        return [
            [this.rule_btn, this.onTouchTap, this],
            [this.myprize_btn, this.onTouchTap, this],
            [this.btn, this.onTouchTap, this],
            [this.shareBtn, this.onTouchTap, this]
        ]
    }

    private onTouchTap(e: egret.TouchEvent) {
        NetManager.ins.clickLog(getlogItem(2));
        switch(e.target) {
            case this.btn:  // 开始按钮，再次开始按钮
                const data = DataManager.ins.getData(NetName.IQIYI_ELEMENT).data;
                const extra = data.extra;
                extra.shared ? NetManager.ins.clickLog(getlogItem(34)) : NetManager.ins.clickLog(getlogItem(21));
                this.btn.touchEnabled = false;
                SceneCtrl.instance.change(ModuleTypes.HBGAME_SCENE);
                this.btn.touchEnabled = true;
                break;
            case this.shareBtn:
                window['iqiyiShare']();
                //     .then(
                //     (res) => {
                //         console.log(res.kShareChannel);
                //         if(res.kShareChannel != 'copyURL') {    // 如果是复制链接，则不算分享成功
                //             NetManager.ins.iqiyiHbRainAddTime((success, res) => {
                //                 if(!success) {
                //                     showToast('分享次数达到上限');
                //                     return;
                //                 }
                //                 showToast('分享成功，获得一次红包雨开抢机会');
                //                 this.ajaxElement();
                //             });
                //         }
                //     },
                //     (err) => {
                //         showToast(err);
                //     }
                // );
                break;
            case this.rule_btn: // 规则按钮
                PanelCtrl.instance.show(ModuleTypes.RULE_PANEL);
                break;

            case this.myprize_btn:  // 我的奖品按钮
                PanelCtrl.instance.btnDelay(this.myprize_btn);
                window.location.href = gotoRecord();
                break;

            default:
                break;
        }
    }

    protected start() {
        super.start();
        NetManager.ins.showLog(getlogItem(2));
        this.initUI();
    }

    private initUI(): void {
        this.scroller.height = this.width / window.innerWidth * window.innerHeight;
        let _str = `抢</spen><u><font color="#72f8fd">${window['hbTips']}</font></u>元现金红包`;
        this.hbLabel.textFlow = new HtmlTextParser().parse(_str);
        this.setMidGroup();
        this.ajaxElement();

        this.documentEvent = () => {
            if(document.visibilityState == "visible") {
                this.ajaxElement();
            }

            if(document.visibilityState == "hidden") {

            }
        };
        document.addEventListener("visibilitychange", () => {
            this.documentEvent();
        });
        window['addTime'] = function(res) {
            NetManager.ins.iqiyiHbRainAddTime((success, res) => {
                if(res.kShareChannel == 'copyURL') {    // 如果是复制链接，则不算分享成功
                    return;
                }
                if(!success) {
                    showToast('分享次数达到上限');
                    return;
                }
                // showToast('分享成功，获得一次红包雨开抢机会');
            });
        }
    }

    private setMidGroup() {
        this.tipsLabel.y = 106;
        this.tipsLabel.text = `距离本场结束还有04:49`;
    }

    private ajaxElement() {
        NetManager.ins.iqiyiAjaxElement((success, res) => {
            // 设置红包
            for(let i = 1; i < 4; i++) {
                this[`hongbao${i}`].source = 'index_hongbao_png';
                this[`label${i}`].alpha = 0.8;
            }
            this.btn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this);

            if(!success || !res || !res.data || !res.data.extra) {
                this.btn.visible = true;
                this.btn.source = 'index_disable_btn_png';
                this.btn.touchEnabled = false;
                this.btn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this);
                this.btn.y = 9;
                this.shareBtn.visible = false;
                this.cutLabel.visible = false;
                this.tipsLabel.visible = false;
                return;
            }
            // console.log(res);
            const extra = res.data.extra;    // 信息
            // 1-活动开始时间前, 2-倒计时, 3-第一场活动期间, 4-第一场结束后, 5-第二场活动期间, 6-第二场结束后, 7-第三场活动期间, 8-第三场结束后(nextTimestamp = -1)
            const currentTimeSlot = extra.currentTimeSlot;
            const nextTimestamp = extra.nextTimestamp;  // 下一个节点时间
            const shared = extra.shared;
            const timestamp = res.timestamp;    // 当前时间
            const canGameArr = [3, 5, 7];

            let _label, _labelText;

            // index_share_btn_png  index_start_btn_png  index_again_btn_png
            if(Utils.isInArray(currentTimeSlot, canGameArr)) {    // 活动进行中
                if(extra.joinCount > 0) {   // 当前可参与
                    this.tipsLabel.y = 106;
                    this.btn.visible = true;
                    this.btn.y = 4;
                    this.shareBtn.visible = false;
                    this.cutLabel.visible = false;
                    this.tips_img.source = 'index_tips_raining_png';
                    this.btn.source = extra.shared ? 'index_again_btn_png' : 'index_start_btn_png'; // 根据是否分享过显示按钮
                    extra.shared ? NetManager.ins.showLog(getlogItem(34)) : NetManager.ins.showLog(getlogItem(21));
                    _label = this.tipsLabel;
                    _labelText = '距离本场结束还有hh:mm:ss';
                } else {
                    if(shared) {
                        this.btn.visible = false;
                        this.shareBtn.visible = false;
                        this.tipsLabel.visible = true;
                        this.tipsLabel.y = 5;
                        switch(true) {
                            case(currentTimeSlot == 1 || currentTimeSlot == 2):
                                this.tipsLabel.text = `距离第一场开始还剩`;
                                break;
                            case(currentTimeSlot == 3 || currentTimeSlot == 4):
                                this.tipsLabel.text = `距离第二场开始还剩`;
                                break;
                            case(currentTimeSlot == 5 || currentTimeSlot == 6):
                                this.tipsLabel.text = `距离第三场开始还剩`;
                                break;
                            default:
                                this.tipsLabel.text = `距离第一场开始还剩`;
                                break;
                        }
                        this.cutLabel.visible = true;
                        this.tips_img.source = 'index_tips_cuting_png';
                        _label = this.cutLabel;
                        _labelText = 'hh时mm分ss秒';
                    } else {
                        this.tipsLabel.y = 106;
                        this.btn.visible = false;
                        this.shareBtn.visible = true;
                        this.cutLabel.visible = false;
                        this.tips_img.source = 'index_tips_raining_png';
                        _label = this.tipsLabel;
                        _labelText = '距离本场结束还有hh:mm:ss';
                    }
                }
            } else { // 倒计时
                if(nextTimestamp == -1 || currentTimeSlot == 8) {
                    this.btn.visible = true;
                    this.btn.source = 'index_disable_btn_png';
                    this.btn.touchEnabled = false;
                    this.btn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this);
                    this.btn.y = 9;
                    this.shareBtn.visible = false;
                    this.cutLabel.visible = false;
                    this.tipsLabel.visible = false;
                } else {
                    this.btn.visible = false;
                    this.shareBtn.visible = false;
                    this.tipsLabel.y = 5;
                    this.tipsLabel.visible = true;
                    switch(true) {
                        case(currentTimeSlot == 1 || currentTimeSlot == 2):
                            this.tipsLabel.text = `距离第一场开始还剩`;
                            break;
                        case(currentTimeSlot == 3 || currentTimeSlot == 4):
                            this.tipsLabel.text = `距离第二场开始还剩`;
                            break;
                        case(currentTimeSlot == 5 || currentTimeSlot == 6):
                            this.tipsLabel.text = `距离第三场开始还剩`;
                            break;
                        default:
                            this.tipsLabel.text = `距离第一场开始还剩`;
                            break;
                    }
                    this.cutLabel.visible = true;
                    this.tips_img.source = 'index_tips_cuting_png';
                    _label = this.cutLabel;
                    _labelText = 'hh时mm分ss秒';
                }
            }

            if(nextTimestamp == -1) {
                this.cutLabel.text = '00时00分00秒';
            } else {
                // 倒计时
                this.cutTimer && this.cutTimer.stop();
                this.cutTimer = new CutTimer(_label, _labelText, () => {
                    this.ajaxElement();
                });
                this.cutTimer.start(nextTimestamp - timestamp + 3000);
            }


            // 红包亮不亮
            switch(currentTimeSlot) {
                case 8:
                case 7:
                    this[`hongbao3`].source = 'index_hongbao_current_png';
                    this[`label3`].alpha = 1;
                case 6:
                case 5:
                    this[`hongbao2`].source = 'index_hongbao_current_png';
                    this[`label2`].alpha = 1;
                case 4:
                case 3:
                    this[`hongbao1`].source = 'index_hongbao_current_png';
                    this[`label1`].alpha = 1;
                case 2:
                case 1:
                default:
                    break
            }
        });
    }

    destroy() {
        super.destroy();
        if(this.cutTimer) {
            this.cutTimer.stop();
            this.cutTimer = null;
        }

        this.documentEvent = () => {
        };
        document.removeEventListener("visibilitychange", () => {
            this.documentEvent();
        })
        window['addTime'] = function(res) {

        }
    }

    protected async preLoadRes() {
        RES.getResAsync('hbGame_3_png');
        RES.getResAsync('hbGame_2_png');
        RES.getResAsync('hbGame_1_png');
    }
}