import { ModuleTypes } from "../types/sceneTypes";
import Panel from "../views/Panel";
import Loading from "../loading/Loading";

export default class PanelCtrl {
    private _parent: eui.UILayer;
    private _mask: egret.Sprite;

    static _instance: PanelCtrl;

    private _current: Panel;


    static get instance() {
        return PanelCtrl._instance || (PanelCtrl._instance = new PanelCtrl())
    }

    public init(parent: eui.UILayer) {
        this._parent = parent;
    }

    private _panelClassMap: any;
    public registerPanelClass(name, definition) {
        this._panelClassMap = this._panelClassMap || {};
        this._panelClassMap[name] = definition;
    }

    public registerPanels(panels) {
        panels.forEach(v => this.registerPanelClass(v[0], v[1]))
    }

    /**
     * 防止连点
     * @param targe 可交互对象
     * @param dtime 延时默认500ms
     */
    public btnDelay(targe: any, dtime: number = 500) {
        targe.touchEnabled = false;
        setTimeout(() => {
            targe.touchEnabled = true;
        }, dtime);
    }

    /**
     * 显示
     * @param type 类型
     * @param data 数据
     * @param afterAni
     */
    public show(type: ModuleTypes, data?, afterAni?: Function) {
        if (this._current) {
            this.remove(this._current, true);
            this._current = null;
        }
        this._parent.visible = true;
        this.addMask();
        const cls = this._panelClassMap[type];
        const panel: Panel = new cls(data);

        Loading.instace.hide();

        this._current = panel;
        this.add(panel);
        panel.visible = false;
        egret.Tween.get(panel).set({visible: true, alpha: 0, y: -200}).to({
            alpha: 1,
            y: 0
        }, 500, egret.Ease.quartOut).call(() => {
            afterAni && afterAni(panel);
        });
        return panel;
    }

    /**
     * 加入黑色蒙层
     */
    private addMask() {
        if(!this._mask) {
            this._mask = new egret.Sprite();
            this._mask.touchEnabled = true;
            this._mask.graphics.beginFill(0, .7);
            this._mask.graphics.drawRect(0, 0, 750, 1624);
            this._mask.graphics.endFill();
        }
        this._mask.alpha = 1;
        this._parent.addChild(this._mask);
    }

    private add(panel: Panel) {
        this._parent.addChild(panel);
        panel.addEventListener('onDestroy', this.onPanelHide, this);
    }

    /**
     * 移除蒙层
     */
    removeMask(rightNow = false) {
        if (this._mask) {
            if (rightNow) {
                this._parent.removeChild(this._mask);
            } else
                egret.Tween.get(this._mask).to({ alpha: 0 }, 300, egret.Ease.quartIn).call(
                    () => this._parent.removeChild(this._mask), this);
        }
        this._parent.visible = false;
    }

    private remove(panel: Panel, rightNow = false) {
        if (rightNow) {
            this._parent.removeChild(panel);
            this.removeMask(rightNow);
            return;
        }
        const tw = egret.Tween.get(panel);
        tw.to({ y: panel.stage.stageHeight }, 300, egret.Ease.quartIn)
            .call(() => {
                this._parent.removeChild(panel);
                this.removeMask();
            }, this);
    }

    /**
     * 隐藏Panel
     * @param e
     */
    private onPanelHide(e: egret.Event) {
        const panel = e.target as Panel;
        panel.removeEventListener('onDestroy', this.onPanelHide, this);
        this.remove(panel);
        this._current=null;
    }
}