import { getSkinPath } from "../utils";
import TopLayerCtrl from "../ctrls/topLayerCtrl";
import { ModuleTypes } from "../types/sceneTypes";

export default class ComponentBase extends eui.Component {
    protected data: any;

    constructor(data?) {
        super();

        this.data = data;

        this.initComponent();
    }

    private async initComponent() {
        await this.preLoadRes();
        console.log('执行了if (!window && this.groupName) {');
        if(!window['development'] && this.groupName) {
            RES.getResByUrl(`${this.groupName}_json`, (sheet: egret.SpriteSheet) => {
                console.log('界面大图加载完');
                this.setSkinName();
            }, this, RES.ResourceItem.TYPE_SHEET);
        } else {
            this.setSkinName();
        }
    }

    /**
     * 是否有要提前加载的资源
     */
    protected async preLoadRes() {
        return new Promise(function(resolve, reject) {
            resolve();
        });
    }

    protected getTapEvts(): any[] {
        return [];
    }

    protected getBeginEvts(): any[] {
        return [];
    }

    protected initEvents() {
        let tapEvts = this.getTapEvts();
        tapEvts.forEach(v => v[0].addEventListener(egret.TouchEvent.TOUCH_TAP, v[1], v[2]));
        let beginEvts = this.getBeginEvts();
        beginEvts.forEach(v => v[0].addEventListener(egret.TouchEvent.TOUCH_BEGIN, v[1], v[2]));
    }

    protected removeEvents() {
        let tapEvts = this.getTapEvts();
        tapEvts.forEach(v => v[0].removeEventListener(egret.TouchEvent.TOUCH_TAP, v[1], v[2]));
        let beginEvts = this.getBeginEvts();
        beginEvts.forEach(v => v[0].removeEventListener(egret.TouchEvent.TOUCH_BEGIN, v[1], v[2]));
    }

    //设置皮肤
    public setSkinName(): void {
        console.log('this.skinKey=' + this.skinKey);
        this.addEventListener(egret.Event.COMPLETE, this.onSkinComplete, this);
        this.skinName = getSkinPath(this.skinKey);
    }

    public get skinKey() {
        return null
    }

    //获取资源组名字
    public get groupName() {
        return null
    }

    protected onSkinComplete() {
        console.log('皮肤加载完成');
        // Loading.instace.hide();
        this.start();
    }

    protected start() {
        this.initEvents();
    }

    destroy() {
        this.removeEvents();
    }

}