import TopLayerCtrl from "../ctrls/topLayerCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { DataManager } from "../../libs/tw/manager/DataManager";

export const showToast = function(msg) {
    TopLayerCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg: msg});
};

/**
 * 获取我的奖品链接
 */
export const gotoRecord = function(): string {
    let recordUrl: string;
    let oaId: number;
    if(DataManager.ins.customCfgData) {
        oaId = DataManager.ins.customCfgData.oaId;
        recordUrl = DataManager.ins.customCfgData.recordUrl;
    } else {
        oaId = DataManager.ins.gameCfgData.gameInfo.oaId;
        recordUrl = window['recordUrl'];
    }

    if(recordUrl.indexOf('?') != -1) {
        recordUrl += '&origins=' + oaId + '00';
    } else {
        recordUrl += '?origins=' + oaId + '00';
    }
    return recordUrl;
};