import Panel from "../../views/Panel";
import { HtmlTextParser } from "../../../libs/tc/util/HtmlTextParser";
import { DataManager } from "../../../libs/tw/manager/DataManager";
import { NetName } from "../../../libs/tw/enum/NetName";

export default class RulePanel extends Panel {
	public closeBtn: eui.Button;
	public ruleLabel: eui.Label;

	public get skinKey() { return 'RulePanel' }
	// public get groupName() { return 'prize_panel' }
	constructor(data?) {
		super(data);

	}

	protected onSkinComplete(): void {
		super.onSkinComplete();

		this.preLoadRes();
		this.onLoad();
		
	}

	protected onLoad(): void {
		this.initUI();
	}

	private initUI(): void {
		let rule = DataManager.ins.getData(NetName.IQIYI_ELEMENT).data.rule;
		this.ruleLabel.textFlow = new HtmlTextParser().parse(rule);
	}
}