import { DataManager } from "../libs/tw/manager/DataManager";
import AssetAdapter from "./AssetAdapter";
import PanelCtrl from "./ctrls/panelCtrl";
import SceneCtrl from "./ctrls/sceneCtrl";
import Loading from "./loading/Loading";
import ThemeAdapter from "./ThemeAdapter";
import { ModuleTypes } from "./types/sceneTypes";
import { getResPath } from "./utils";
import layers from "./views/layers";
import { PetIndexData } from "../libs/tw/data/pet/PetIndexData";
import { Buried } from '../libs/tw/util/Buried';
import LoadingScene from './loadingScene/loadingScene';
import { GDispatcher } from '../libs/tc/util/GDispatcher';
import TopLayerCtrl from './ctrls/topLayerCtrl';
import ToastPanel from './toastPanel/ToastPanel';

//////

import RulePanel from "./Panels/RulePanel/RulePanel";
import IndexScene from "./indexScene/IndexScene";
import HbPrize from "./HongbaoRain/HbPrize";
import HbNoPrize from "./HongbaoRain/HbNoPrize";
import HbGame from "./HongbaoRain/HbGame";
import NoNetWorkPanel from "./Panels/NoNetWorkPanel";
import { initstatistics } from "./statistics";

//////

class Main extends eui.UILayer {
    protected createChildren(): void {
        super.createChildren();

        egret.lifecycle.addLifecycleListener((context) => {
            // custom lifecycle plugin
        });

        let assetAdapter = new AssetAdapter();
        egret.registerImplementation("eui.IAssetAdapter", assetAdapter);
        egret.registerImplementation("eui.IThemeAdapter", new ThemeAdapter());

        egret.ImageLoader.crossOrigin = "anonymous";

        DataManager.ins.petIndexData = new PetIndexData();
        DataManager.ins.petIndexData.update(window['CFG']);
        // NetManager.ins.getCredits(()=>{});

        layers.init(this);
        Loading.init(layers.topLayer);
        PanelCtrl.instance.init(layers.popupLayer);
        SceneCtrl.instance.init(layers.sceneLayer);
        TopLayerCtrl.instance.init(layers.topLayer);

        this.stage.scaleMode = egret.StageScaleMode.FIXED_WIDTH;

        // 注册Scene
        SceneCtrl.instance.registerScenes([
            [ModuleTypes.LOADING_SCENE, LoadingScene],
            [ModuleTypes.INDEX_SCENE, IndexScene],
            [ModuleTypes.HBGAME_SCENE, HbGame],
        ]);

        // 注册Panel
        PanelCtrl.instance.registerPanels([
            [ModuleTypes.RULE_PANEL, RulePanel],
            [ModuleTypes.HBPRIZE_PANEL, HbPrize],
            [ModuleTypes.HBNOPRIZE_PANEL, HbNoPrize],
            [ModuleTypes.NO_NETWORK_PANEL, NoNetWorkPanel],
        ]);

        TopLayerCtrl.instance.registerPanelClass(ModuleTypes.TOAST_PANEL, ToastPanel);

        this.runGame().catch(e => {
            console.log(e);
        })
    }

    private async runGame() {
        await this.loadResource()
        this.createGameScene();
        // RES.loadGroup("msg", 10);
    }

    private async loadResource() {
        try {
            // const loadingView = new LoadingUI();
            // this.stage.addChild(loadingView);
            await RES.loadConfig("default.res.json", getResPath() + "resource/");
            await this.loadTheme();

            // await RES.loadGroup("msg", 10);
            // this.stage.removeChild(loadingView);
        } catch(e) {
            console.error(e);
        }
    }

    private loadTheme() {
        return new Promise((resolve, reject) => {
            // load skin theme configuration file, you can manually modify the file. And replace the default skin.
            //加载皮肤主题配置文件,可以手动修改这个文件。替换默认皮肤。
            let theme = new eui.Theme("resource/default.thm.json", this.stage);
            theme.addEventListener(eui.UIEvent.COMPLETE, () => {
                resolve();
            }, this);

        })
    }


    /**
     * 创建场景界面
     * Create scene interface
     */
    protected createGameScene(): void {
        //获取签到信息
        DataManager.ins.customCfgData = window["CFG"];
        Buried.init();
        // NetManager.ins.ajaxElement((success) => {
        //     if(!success) {
        //         return;
        //     }
        //     // GDispatcher.addEvent(ABNetManager.ERROR, this.onError, this);
        //     this.getGameRes();
        // });
        this.getGameRes();
        initstatistics();
    }

    //加载游戏中的资源
    private async getGameRes() {
        SceneCtrl.instance.change(ModuleTypes.INDEX_SCENE);

        await RES.loadGroup('common');
        await RES.loadGroup('index_scene');

        // GDispatcher.dispatchEvent('progress', [100]);
    }
}

window['Main'] = Main;