import { GDispatcher } from "../../libs/tc/util/GDispatcher";
import RainData from "./RainData";
import { getResPath } from "../utils";
import { loadSvga } from "../loadSvga";

export default class RainObj {
    private data = null;
    private module: eui.Image = null;

    private rainGroup = null;

    private speed:number = 400;

    constructor(data) {
        this.data = data;
        this.module = new eui.Image(`hbGame_${this.data.key}_png`);
        this.module.anchorOffsetX = 75;
        this.module.anchorOffsetY = 70;
        this.rainGroup = this.data.rainGroup;
    }

    public addStage(x, scale) {
        this.module.x = x;
        this.module.y = -200;
        this.module.scaleX = this.module.scaleY = scale;
        this.module.visible = true;
        this.rainGroup.addChild(this.module);
        this.start();
    }

    private start() {
        this.module.alpha = 1;
        this.module.touchEnabled = true;
        this.module.source = `hbGame_${this.data.key}_png`;
        this.module.addEventListener(egret.TouchEvent.TOUCH_BEGIN, this.touchTap, this);
        egret.Tween.get(this.module, {loop: true}).to({rotation: ~~(Math.random() * 2) ? 360 : -360}, 18000);
        let ms = (this.rainGroup.height + 200) / this.speed * 1000;
        // console.log(ms);
        egret.Tween.get(this.module).to({y: this.rainGroup.height + 200}, ms).call(() => this.destroy());
    }

    private touchTap() {
        egret.Tween.removeTweens(this.module);
        this.moduleEffect();    // 模型特效
        GDispatcher.dispatchEvent('setSubmit');
        GDispatcher.dispatchEvent('hbGameAddScore', RainData.data[this.data.key].score);    // 加分
        this.destroy();
    }

    // 模型特效
    private moduleEffect() {
        let _scaleX = this.module.scaleX;
        let _scaleY = this.module.scaleY;
        egret.Tween.get(this.module).to({scaleX: _scaleX + 0.2, scaleY: _scaleY + 0.2}, 100).call(() => {
            egret.Tween.get(this.module).to({scaleX: _scaleX, scaleY: _scaleY}, 100).call(() => {
                loadSvga(getResPath() + 'resource/assets/svgas/hbRainHb.svga', this.rainGroup).then((mv: any) => {
                    mv.x = this.module.x - 180 * this.module.scaleX;
                    mv.y = this.module.y - 250 * this.module.scaleY;
                    mv.touchEnable = false;
                    mv.scaleX = this.module.scaleX;
                    mv.scaleY = this.module.scaleY;
                    mv.once(egret.Event.COMPLETE, () => {
                        mv.stop();
                        this.rainGroup.removeChild(mv);
                    }, this);
                });
                egret.Tween.get(this.module).to({alpha: 0}, 500);
            })
        });
    }

    private destroy() {
        this.module.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.touchTap, this);
        this.module.touchEnabled = false;
        setTimeout(() => {
            this.rainGroup.removeChild(this.module);
            this.data.pool.push(this);
        }, 600);
    }
}