import RainObj from "./RainObj";
import RainData from "./RainData";
import Pooling from "./Pooling";
import { GDispatcher } from "../../libs/tc/util/GDispatcher";
import Utils from "../comm/Utils";

export default class RainMgr {
    private rainPool: Pooling = null;

    private data;
    private parent;
    private readonly rainGroup;
    private timer: egret.Timer = null;


    constructor(data) {
        this.data = data;
        this.parent = this.data.parent;
        this.rainGroup = this.data.rainGroup;

        this.start();
    }

    public gameOver() {
        this.timer.stop();  // 停止计时器
        this.timer.removeEventListener(egret.TimerEvent.TIMER, this.addRain, this);

        // 隐藏全部掉落物品
        this.rainGroup.$children.forEach(v => v.visible = false);
    }

    private start() {
        this.addPool();

        GDispatcher.addEvent('hbRainGameOver', this.gameOver, this);

        this.timer = new egret.Timer(1000, 0);
        this.timer.addEventListener(egret.TimerEvent.TIMER, this.addRain, this);
        this.timer.start();
        this.addRain();
    }

    // 添加掉落物品
    private addRain() {
        let num = Utils.RandomInt(3, 6);
        for(let i = 0; i < num; i++) {
            let newRainObj = this.rainPool.get();
            if(!newRainObj) {
                newRainObj = new RainObj({
                    key: RainData.key[~~(Math.random() * RainData.key.length)],
                    rainGroup: this.rainGroup,
                    pool: this.rainPool,
                });
            }
            setTimeout(() => {
                newRainObj.addStage((this.rainGroup.width) / num * i + 100, Utils.RandomInt(8, 11) / 10);
            }, Utils.RandomInt(0, 8) * 100);
        }
    }

    private addPool() {
        this.rainPool = new Pooling();
        for(let v of RainData.key) {
            let num = 1;
            if(v == 'hongbao') {
                num = 45;
            }
            for(let i = 0; i < num; i++) {
                let newObj = new RainObj({
                    key: v,
                    rainGroup: this.rainGroup,
                    pool: this.rainPool,
                });
                this.rainPool.push(newObj);
            }
        }
    }
}