/**
 * 红包雨奖励
 */
import { getSkinPath } from "../utils";
import Panel from "../views/Panel";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { gotoRecord, showToast } from "../comm/UtilsConst";
import PanelCtrl from "../ctrls/panelCtrl";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { DatapashData } from "../../libs/tw/data/game/datapash/DatapashData";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetName } from "../../libs/tw/enum/NetName";
import { getlogItem } from "../getlogItem";

export default class HbPrize extends Panel {
    public closeBtn:eui.Button;
    public prizeName:eui.Label;
    public prizeImg:eui.Image;
    public ok_btn:eui.Button;
    public share_btn:eui.Button;
    public shareTips:eui.Image;

    constructor(data) {
        super(data);
    }

    protected start() {
        super.start();
        NetManager.ins.showLog(getlogItem(13));
        this.initUI();
    }

    initUI() {
        const data = DataManager.ins.getData(NetName.IQIYI_ELEMENT).data;
        const extra = data.extra;
        if(extra.shared) {
            this.share_btn.visible = false;
            this.shareTips.visible = false;
            this.ok_btn.x = 146;
        } else {
            this.share_btn.visible = true;
            this.shareTips.visible = true;
            this.ok_btn.x = 0;
        }
        // console.log(this.data);
        this.prizeImg.source = this.data.imgUrl;
        this.prizeName.text = `恭喜你获得${this.data.title}`;

        let that = this;
        window['addTime'] = function(res) {
            NetManager.ins.iqiyiHbRainAddTime((success, res) => {
                if(res.kShareChannel == 'copyURL') {    // 如果是复制链接，则不算分享成功
                    return;
                }
                that.onTouchClose();
                if(!success) {
                    showToast('分享次数达到上限');
                    return;
                }
                // showToast('分享成功，获得一次红包雨开抢机会');
            });
        }
    }

    private onTouchTap(e: egret.TouchEvent) {
        NetManager.ins.clickLog(getlogItem(13));
        PanelCtrl.instance.btnDelay(e.target);
        switch(e.target) {
            case this.ok_btn:   // 去我的奖品页
                window.location.href = gotoRecord();
                break;
            case this.share_btn:    // 爱奇艺主动分享
                window['iqiyiShare']();
                //     .then(
                //     (res) => {
                //         console.log(res.kShareChannel);
                //         if(res.kShareChannel != 'copyURL') {    // 如果是复制链接，则不算分享成功
                //             NetManager.ins.iqiyiHbRainAddTime((success, res) => {
                //                 this.onTouchClose();
                //                 if(!success) {
                //                     showToast('分享次数达到上限');
                //                     return;
                //                 }
                //                 // let iqiyiAjaxData = DataManager.ins.getData(NetName.IQIYI_ELEMENT).data;
                //                 // if(iqiyiAjaxData && iqiyiAjaxData.extra && !iqiyiAjaxData.extra.shared){ // 没有分享过
                //                 //     showToast('分享成功，获得一次红包雨开抢机会');
                //                 // }
                //             });
                //         }
                //     },
                //     (err) => {
                //         showToast(err);
                //     }
                // );
                break;

            default:
                break;
        }
    }

    onTouchClose(): any {
        super.onTouchClose();
        SceneCtrl.instance.change(ModuleTypes.INDEX_SCENE);
    }

    protected getTapEvts() {
        return super.getTapEvts().concat([
            [this.ok_btn, this.onTouchTap, this],
            [this.share_btn, this.onTouchTap, this],
        ]);
    }

    destroy() {
        super.destroy();
        window['addTime'] = function(res) {

        }
    }

    get skinKey() {
        return 'HbPrize'
    }

    get groupName() {
        return "hbPrize";
    }


};

///////////////////////////////////////////////////////////////////////////////////////
/**
 * 奖品列表
 */
class HbPrizeItem extends eui.ItemRenderer {
    public prizeLabel: eui.Label;

    constructor() {
        super();
        this.skinName = getSkinPath('HbPrizeItem');
    }

    dataChanged() {
        console.log(this.prizeLabel.text);
        console.log(this.data);
    }
}
