/**
 * 红包雨无奖励
 */
import Panel from "../views/Panel";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import PanelCtrl from "../ctrls/panelCtrl";
import { showToast } from "../comm/UtilsConst";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { getlogItem } from "../getlogItem";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetName } from "../../libs/tw/enum/NetName";

export default class HbNoPrize extends Panel {
    public closeBtn:eui.Button;
    public ok_btn:eui.Button;
    public share_btn:eui.Button;
    public shareTips:eui.Image;

    constructor(data) {
        super(data);
    }

    protected start() {
        super.start();
        NetManager.ins.showLog(getlogItem(35));
        this.initUI();
    }

    initUI() {
        const data = DataManager.ins.getData(NetName.IQIYI_ELEMENT).data;
        const extra = data.extra;
        if(extra.shared) {
            this.share_btn.visible = false;
            this.shareTips.visible = false;
            this.ok_btn.x = 240;
        } else {
            this.share_btn.visible = true;
            this.shareTips.visible = true;
            this.ok_btn.x = 102;
        }

        let that = this;
        window['addTime'] = function(res) {
            NetManager.ins.iqiyiHbRainAddTime((success, res) => {
                if(res.kShareChannel == 'copyURL') {    // 如果是复制链接，则不算分享成功
                    return;
                }
                that.onTouchClose();
                if(!success) {
                    showToast('分享次数达到上限');
                    return;
                }
                // showToast('分享成功，获得一次红包雨开抢机会');
            });
        }
    }

    private onTouchTap(e: egret.TouchEvent) {
        NetManager.ins.clickLog(getlogItem(35));
        PanelCtrl.instance.btnDelay(e.target);
        switch(e.target) {
            case this.ok_btn:   // 去我的奖品页
                this.onTouchClose();
                break;
            case this.share_btn:    // 爱奇艺主动分享
                window['iqiyiShare']();
                //     .then(
                //     (res) => {
                //         console.log(res.kShareChannel);
                //         if(res.kShareChannel != 'copyURL') {    // 如果是复制链接，则不算分享成功
                //             NetManager.ins.iqiyiHbRainAddTime((success, res) => {
                //                 this.onTouchClose();
                //                 if(!success) {
                //                     showToast('分享次数达到上限');
                //                     return;
                //                 }
                //                 // showToast('分享成功，获得一次红包雨开抢机会');
                //             });
                //         }
                //     },
                //     (err) => {
                //         console.log(err);
                //     }
                // );
                break;

            default:
                break;
        }
    }

    onTouchClose(): any {
        super.onTouchClose();
        SceneCtrl.instance.change(ModuleTypes.INDEX_SCENE);
    }

    protected getTapEvts(): any[] {
        return super.getTapEvts().concat([
            [this.ok_btn, this.onTouchTap, this],
            [this.share_btn, this.onTouchTap, this]
        ])
    }


    get skinKey() {
        return 'HbNoPrize'
    }

    get groupName() {
        return "hbNoPrize";
    }

    destroy() {
        super.destroy();
        window['addTime'] = (res)=>{

        }
    }
}
