import RainMgr from "./RainMgr";
import { GDispatcher } from "../../libs/tc/util/GDispatcher";
import Scene from "../views/Scene";
import Utils from "../comm/Utils";
import { JoinGame, Submit } from "../comm/NetConst";
import PanelCtrl from "../ctrls/panelCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetName } from "../../libs/tw/enum/NetName";

/**
 * 红包雨主游戏
 */
export default class HbGame extends Scene {
    public cutTimeGroup: eui.Group;
    public cutLabel: eui.Label;
    public rainGroup: eui.Group;
    public readyGroup: eui.Group;
    public readyTips: eui.Image;
    public readyCutTime: eui.Image;

    private rainMgr: RainMgr = null;

    private time: number = window['hbRainTime'] * 1000;

    private score = 0;
    private lastTime: number = egret.getTimer();

    constructor(data) {
        super();
        this.data = data;
    }

    protected start() {
        super.start();
        this.onLoad();
    }

    onLoad() {
        this.initUI();
        this.readyTipsEffect();
    }

    initUI() {
        this.rainGroup.height = this.width / window.innerWidth * window.innerHeight;
        this.setCutLabel();

        GDispatcher.addEvent('setSubmit', this.setSubmit, this);
    }

    private hasCall: boolean = false;

    setSubmit() {
        if(this.hasCall) {
            return;
        }
        let wait = Math.random() * (window['hbRainTime'] * 1000 - (window['hbRainTime'] * 1000 - this.time) - 3000);
        // console.log(wait);
        if(wait >= 0) {
            this.hasCall = true;
            setTimeout(() => {
                JoinGame().then(
                    (res) => {
                        Submit().then(
                            (res) => {
                            },
                            (err) => {
                            }
                        )
                    },
                    (err) => {

                    }
                );
            }, wait);
        }
        GDispatcher.removeEvent('setSubmit', this.setSubmit, this);
    }

    // private randomSubmit() {
    //     let wait = (Math.random() * 12 + 3) * 1000;
    //     console.log(wait);
    //     setTimeout(() => {
    //         Submit().then(
    //             (res) => {
    //             },
    //             (err) => {
    //             }
    //         )
    //     }, wait);
    // }

    // 加分
    private addScore(score: number) {
        this.score += score;
    }

    private gameOver() {
        let success = () => {
            const res = DataManager.ins.getData(NetName.GET_ORDER_STATUS);
            if(!res || !res.success) {
                PanelCtrl.instance.show(ModuleTypes.HBNOPRIZE_PANEL);
            } else {
                const data = res['data'] || null;
                if(!data || !data.lottery || data.lottery.type == 'thanks') {
                    PanelCtrl.instance.show(ModuleTypes.HBNOPRIZE_PANEL);
                    return;
                }
                PanelCtrl.instance.show(ModuleTypes.HBPRIZE_PANEL, data.lottery);
            }
        };

        this.rainMgr.gameOver();
        // 获取提交游戏的数据并弹窗
        if(this.score <= 0) {
            PanelCtrl.instance.show(ModuleTypes.HBNOPRIZE_PANEL);
        } else {
            if(!this.hasCall) {
                JoinGame().then(
                    (res) => {
                        Submit().then(
                            (res) => {
                                success();
                            },
                            (err) => {
                            }
                        )
                    },
                    (err) => {

                    }
                );
            } else {
                success();
            }
        }
    }

    private startGame() {
        // this.randomSubmit();    // 计算时间提交游戏 出奖（分流量）

        this.rainMgr = new RainMgr({
            parent: this,
            rainGroup: this.rainGroup,
        });

        this.update = () => {
            let currentTime: number = egret.getTimer();		// 当前时间
            let dt: number = currentTime - this.lastTime;	// 帧时间
            this.timeCallFun(dt);
            this.lastTime = egret.getTimer();	// 上一帧结束的时间
        };

        this.lastTime = egret.getTimer();
        egret.lifecycle.addLifecycleListener((context) => {
            context.onUpdate = () => {
                this.update();
            }
        });
    }

    private update() {
    }

    private timeCallFun(dt) {
        this.time -= dt;
        if(this.time <= 0) {
            this.time = 0;
            this.gameOver();
            this.update = () => {
            };
        }
        this.setCutLabel();
    }

    private setCutLabel() {
        let ms: any = this.time % 1000;
        if(ms >= 100) {
            ms = ~~(ms / 10);
        }
        ms = Utils.prefixInteger(ms, 2);
        let s = Utils.prefixInteger(~~(this.time / 1000), 2);
        this.cutLabel.text = `${s}:${ms}`;
    }

    private readyTipsEffect() {
        egret.Tween.get(this.readyGroup).set({alpha: 0}).to({alpha: 1}, 300).call(() => {
            this.readyCutTime.anchorOffsetX = 196 / 2;
            this.readyCutTime.anchorOffsetY = 377 / 2;
            this.readyCutTime.y += this.readyCutTime.anchorOffsetY;
            this.readyGroup.visible = true;
            let data = {
                num: 3,
                obj: this.readyCutTime,
                scaleMin: 0, // 缩放最小值
                scaleMax: 1.7,    // 缩放最大值
                t1: 430,          // 缩放第一阶段时间
                tw: 50,           // 缩放中间停留时间     // t1 + tw + t2 = 1000; 1秒
                t2: 520,          // 缩放第二阶段时间
                alpha: 0.1,            // 最小透明度
                ease: egret.Ease.quadInOut
            };
            this.readyGroupEffect(data);
        });
    }

    private readyGroupEffect(d) {
        d.obj.source = `hbGame_${d.num--}_png`
            , d.obj.scaleX = d.obj.scaleY = d.scaleMin
            , d.obj.alpha = 1;
        egret.Tween.get(d.obj).to({scaleX: 1, scaleY: 1, alpha: 1}, d.t1, d.ease).wait(d.tw).call(() => {
            egret.Tween.get(d.obj).to({scaleX: d.scaleMax, scaleY: d.scaleMax, alpha: d.alpha}, d.t2).call(() => {
                (d.num === 0) ? this.startGameEffect() : this.readyGroupEffect(d);
            })
        });
    }

    private startGameEffect() {
        this.readyGroupHide();
        this.cutGroupEffect();
    }

    private readyGroupHide() {
        egret.Tween.get(this.readyGroup).to({alpha: 0}, 300).call(() => {
            this.readyGroup.visible = false;
            this.readyGroup.touchEnabled = false;
        })
    }

    private cutGroupEffect() {
        this.cutTimeGroup.visible = true;
        egret.Tween.get(this.cutTimeGroup).to({y: 0}, 300).call(() => {
            this.startGame();
        })
    }

    destroy() {
        super.destroy();
        GDispatcher.removeEvent('setSubmit', this.setSubmit, this);
    }

    initEvents() {
        super.initEvents();
        GDispatcher.addEvent('hbGameAddScore', this.addScore, this);
    }

    removeEvents() {
        super.removeEvents();
        GDispatcher.removeEvent('hbGameAddScore', this.addScore, this);
    }

    get skinKey() {
        return 'HbGame'
    }

    get groupName() {
        return 'hbRainGame'
    }
}
