"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
var ActivityModel_1 = require("./ActivityModel");
var NetManager_1 = require("../../manager/NetManager");
var DataManager_1 = require("../../manager/DataManager");
var SignModel = (function (_super) {
    __extends(SignModel, _super);
    function SignModel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * 领养
     * @param callback
     */
    SignModel.prototype.petAdopte = function (callback, petName) {
        NetManager_1.NetManager.ins.petAdopte(callback, DataManager_1.DataManager.ins.petIndexData.activityId, petName);
    };
    /**
     * 获取宠物信息
     * @param callback
     */
    SignModel.prototype.getPetInfo = function (callback) {
        NetManager_1.NetManager.ins.getPetInfo(callback, DataManager_1.DataManager.ins.petIndexData.activityId);
    };
    /**
     * 宠物喂食
     * @param callback
     * @param feedNum:喂食数量
     */
    SignModel.prototype.petFeed = function (callback, feedNum) {
        NetManager_1.NetManager.ins.petFeed(callback, DataManager_1.DataManager.ins.petHomeInfoData.petId, feedNum);
    };
    /**
     * 宠物状态刷新
     * @param callback
     */
    SignModel.prototype.getPetStatus = function (callback) {
        NetManager_1.NetManager.ins.getPetStatus(callback, DataManager_1.DataManager.ins.petHomeInfoData.petId);
    };
    /**
     * 签到接口
     * @param {Function} callback
     * @param {number} signActivityId 签到插件ID
     */
    SignModel.prototype.doSign = function (callback, signActivityId) {
        NetManager_1.NetManager.ins.doSign(callback, signActivityId, DataManager_1.DataManager.ins.petIndexData.activityId);
    };
    /**
     * 收取礼物接口
     * @param callback
     * @param {number} giftId 礼物id
     * @param {string} giftName 礼物名称
     * @param {string} giftDesc 礼物描述
     * @param {number} giftType 礼物类型 1：用户自定义， 2：食物
     * @param {string} giftLink 礼物链接
     * @param {number} petId 宠物id
     */
    SignModel.prototype.collect = function (callback, giftId, giftNum, giftName, giftDesc, giftType, giftLink) {
        NetManager_1.NetManager.ins.collect(callback, giftId, giftNum, giftName, giftDesc, giftType, giftLink, DataManager_1.DataManager.ins.petHomeInfoData.petId);
    };
    Object.defineProperty(SignModel.prototype, "petIndexData", {
        /**
         * 用户基础数据
         */
        get: function () {
            return DataManager_1.DataManager.ins.petIndexData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SignModel.prototype, "petHomeInfoData", {
        /**
         * 宠物基础数据
         */
        get: function () {
            return DataManager_1.DataManager.ins.petHomeInfoData;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SignModel.prototype, "signInfoData", {
        /**
         * 签到详情数据
         */
        get: function () {
            return DataManager_1.DataManager.ins.signInfoData;
        },
        enumerable: true,
        configurable: true
    });
    return SignModel;
}(ActivityModel_1.ActivityModel));
exports.SignModel = SignModel;
__reflect(SignModel.prototype, "\"/Users/chiwang/Desktop/\u5151\u5427\u5DE5\u4F5C/gameegret20181011/db-game-template/egret/libs/tw/model/common/SignModel\".SignModel");
//# sourceMappingURL=SignModel.js.map