import Land from "./Objs/Land";
import {MainDispatcher, MainIns} from "./MainScene";
import {NetManager} from "../../../libs/tw/manager/NetManager";
import {GDispatcher} from "../../../libs/tc/util/GDispatcher";
import {loadSvga} from "../../comm/loadSvga";
import {getSvga} from "../../utils";
import M_EVENT from "./MSceneEnum";
import {M_HideOption} from "./Objs/OptionPanel";
import MovieClip = egret.MovieClip;

/**
 * 示意图
 *    ////////////
 *   /////1 1////    ////////////
 *  /////1 1////    /////2 2////
 * ////////////    /////2 2////
 *                ////////////
 *    ////////////
 *   /////3 3////    ////////////
 *  /////3 3////    /////4 4////
 * ////////////    /////4 4////
 *                ////////////
 *    ////////////
 *   /////5 5////    ////////////
 *  /////5 5////    /////6 6////
 * ////////////    /////6 6////
 *                ////////////
 */

const landPos = [   // 地块位置（注意顺序，影响层级）
    {x: 189, y: 554},
    {x: 422, y: 640},
    {x: 106, y: 725},
    {x: 318, y: 835},
    {x: 49, y: 942},
    {x: 295, y: 1052},
];

export default class LandMgr {
    private _parent: egret.DisplayObject = null;
    public get parent() {
        return this._parent;
    }

    public lands: Land[] = [];

    constructor(parent: egret.DisplayObject) {
        this._parent = parent;

        this.initEvents();
        this.getLandInfo();
    }

    private initEvents() {
        MainDispatcher.addEvent(M_EVENT.HIDE_OPTION, this.reActiveAll, this);
        GDispatcher.addEvent('docVisible', this.updateLandInfo, this);
        MainDispatcher.addEvent(M_EVENT.UPDATE_LANDS, this.updateLandInfo, this);
        MainDispatcher.addEvent(M_EVENT.PLANT, this.plant, this);
    }

    public destroy() {
        this.lands.forEach((v, i) => {
            v.destroy();
            this.lands[i] = v = null;
        });
        MainDispatcher.removeEvent(M_EVENT.HIDE_OPTION, this.reActiveAll, this);
        GDispatcher.removeEvent('docVisible', this.updateLandInfo, this);
        MainDispatcher.removeEvent(M_EVENT.UPDATE_LANDS, this.updateLandInfo, this);
        MainDispatcher.removeEvent(M_EVENT.PLANT, this.plant, this);
    }

    private plant(data) {
        this.lands[data.landId - 1].plant(data);
    }


    private reActiveAll() {
        this.lands.forEach((v) => v.reActive());
    }

    /**
     * 添加地块
     */
    private async addLand(data) {
        for (let v of data) {
            let newLand = new Land({data: v, index: v.id, x: landPos[v.id - 1].x, y: landPos[v.id - 1].y});
            MainIns().gameLayer.addChildAt(newLand, v.id);
            this.lands.push(newLand);   // 加入数组方便管理
        }
        const mv = await loadSvga(getSvga('流水动效'));
        mv.x = 550;
        mv.y = 865;
        mv.touchEnabled = false;
        MainIns().gameLayer.addChild(mv);
    }

    private getLandInfo() {
        NetManager.ins.getLandInfo((success, res) => {
            if (!success) {
                return;
            }
            this.addLand(res.data);
        });
    }

    /// TODO 最好做个防抖，避免请求频繁
    private updateLandInfo(id?) {
        console.log('Update Lands', id);
        NetManager.ins.getLandInfo((success, res) => {
            // M_HideOption(); /// TODO 好像没用。。。。
            if (!success) {
                return;
            }

            if (id) {   // 更新单个
                const index = id - 1;
                const land = this.lands[index];
                const data = res.data[index];
                land.updateData({data, index: data.id, x: landPos[index].x, y: landPos[index].y});
            } else {   // 更新全部
                for (let i = 0; i < res.data.length; i++) {
                    let v = res.data[i];
                    this.lands[i].updateData({data: v, index: v.id, x: landPos[v.id - 1].x, y: landPos[v.id - 1].y});
                }
            }

            // 显示xiaoE随机提示 TODO 2020.12.26 需求不需要
            // let flag = true;
            // for (let i = 0; i < res.data.length; i++) {
            //     let v = res.data[i];
            //     if (v.canGather) {
            //         flag = false;
            //         MainIns().showXiaoETip('get');
            //         break;
            //     } else if (!v.lock && !v.petId) {
            //         flag = false;
            //         MainIns().showXiaoETip('plant');
            //         break;
            //     }
            // }
            //
            // if (flag) {
            //     MainIns().showXiaoETip(Math.random() > 0.5 ? 'whooo' : 'miss');
            // }

        });
    }
}

const M_UpdateLand = function (id?) {
    MainDispatcher.dispatchEvent(M_EVENT.UPDATE_LANDS, id);
};

const M_Plant = function (data: { landId: number, petId: number }) {
    MainDispatcher.dispatchEvent(M_EVENT.PLANT, data);
};

export {M_UpdateLand, M_Plant}
