"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * 简单对象池
 */
var Polling = (function () {
    function Polling() {
        this.pool = [];
    }
    /**
     * 存入对象
     * @param obj - 要存入的对象
     */
    Polling.prototype.push = function (obj) {
        this.pool.push(obj);
    };
    /**
     * 返回对象池中的随机对象
     * @returns 返回获得的对象  null 对象用完了
     */
    Polling.prototype.get = function () {
        if (this.pool.length <= 0) {
            return null;
        }
        // 返回随机对象
        var index = ~~(Math.random() * this.pool.length);
        var obj = this.pool[index];
        this.pool.splice(index, 1);
        return obj;
    };
    /**
     * 清空对象池
     */
    Polling.prototype.clear = function () {
        for (var i = 0; i < this.pool.length; i++) {
            delete this.pool[i];
        }
        this.pool = [];
    };
    return Polling;
}());
exports.default = Polling;
__reflect(Polling.prototype, "\"/Users/haiyoucuv/Documents/Web/\u5DE5\u884C\u5361\u4E2D\u5FC3--\u6B22\u8DA3\u5E84\u56ED\u6D3B\u52A8/JoyousManor/egret/src/comm/Pooling\".Polling");
//# sourceMappingURL=Pooling.js.map