"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
var Panel_1 = require("../views/Panel");
var MainScene_1 = require("../Scenes/MainScene/MainScene");
var SelledPanel = (function (_super) {
    __extends(SelledPanel, _super);
    function SelledPanel(data) {
        return _super.call(this, data) || this;
    }
    Object.defineProperty(SelledPanel.prototype, "skinKey", {
        get: function () {
            return 'SelledPanel';
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SelledPanel.prototype, "groupName", {
        get: function () {
            return 'selled_panel';
        },
        enumerable: true,
        configurable: true
    });
    SelledPanel.prototype.onShowAnim = function () {
        // const canvasH = 750 / window.innerWidth * window.innerHeight;
        egret.Tween.get(this).set({ alpha: 0 }).to({ alpha: 1 }, 233, egret.Ease.quadInOut);
    };
    SelledPanel.prototype.start = function () {
        _super.prototype.start.call(this);
        this.initUI();
        this.okBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchClose, this);
        MainScene_1.MainDispatcher.dispatchEvent('updateWareHouse');
    };
    SelledPanel.prototype.onTouchClose = function () {
        MainScene_1.MainDispatcher.dispatchEvent('closeWareHouse');
        MainScene_1.MainIns().mainUI.addGold(); // 收豆子的动画
        _super.prototype.onTouchClose.call(this);
    };
    SelledPanel.prototype.initUI = function () {
        this.y = 750 / window.innerWidth * window.innerHeight * 0.2;
        this.infoLabel.text = "\u60A8\u7684" + this.data.name + "\u5DF2\u88AB\u6B22\u8DA3\u5546\u5E97\u6536\u4E0B";
        this.numLabel.text = "\u4E3A\u60A8\u732E\u4E0A" + this.data.total + "\u4E2A\u6B22\u8DA3\u8C46";
    };
    SelledPanel.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
        this.okBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchClose, this);
    };
    return SelledPanel;
}(Panel_1.default));
exports.default = SelledPanel;
__reflect(SelledPanel.prototype, "\"/Users/haiyoucuv/Documents/Web/\u5DE5\u884C\u5361\u4E2D\u5FC3--\u6B22\u8DA3\u5E84\u56ED\u6D3B\u52A8/JoyousManor/egret/src/Panels/SelledPanel\".SelledPanel");
//# sourceMappingURL=SelledPanel.js.map