/**
 * 简单对象池
 */
export default class Polling {

    private pool: any[] = [];

    constructor() {

    }

    /**
     * 存入对象
     * @param obj - 要存入的对象
     */
    public push(obj: any) {
        this.pool.push(obj);
    }

    /**
     * 返回对象池中的随机对象
     * @returns 返回获得的对象  null 对象用完了
     */
    public get() {
        if (this.pool.length <= 0) {  // 如果对象池用完了就返回 null
            return null;
        }
        // 返回随机对象
        let index = ~~(Math.random() * this.pool.length);
        let obj = this.pool[index];
        this.pool.splice(index, 1);
        return obj
    }

    /**
     * 清空对象池
     */
    public clear() {
        for (let i = 0; i < this.pool.length; i++) {
            delete this.pool[i];
        }
        this.pool = [];
    }
}