import { GDispatcher } from "../../libs/tc/util/GDispatcher";

//设置隐藏属性和改变可见属性的事件的名称
let hidden, visibilityChange;
switch(true) {
    default:
    case (typeof document.hidden !== 'undefined'):
        hidden = 'hidden';
        visibilityChange = 'visibilitychange';
        break;
    case (typeof document['msHidden'] !== 'undefined'):
        hidden = 'msHidden';
        visibilityChange = 'msvisibilitychange';
        break;
    case (typeof document['webkitHidden'] !== 'undefined'):
        hidden = 'webkitHidden';
        visibilityChange = 'webkitvisibilitychange';
        break;
}

const handleVisibilityChange = (e) => {
    if(document.visibilityState == "visible") {
        GDispatcher.dispatchEvent('docVisible');
        console.log('document visible');
    }

    if(document.visibilityState == "hidden") {
        GDispatcher.dispatchEvent('docHide');
        console.log('document hidden');
    }
};

export const docEvent = () => {
    document.addEventListener(
        visibilityChange,
        handleVisibilityChange,
        false
    );

    // 页面重载
    document.body['onbeforeunload'] = () => {
        GDispatcher.dispatchEvent('onbeforeunload');
        console.log('document onbeforeunload');
    }
};
