import Scene from "../../views/Scene";
import { btnDelay } from "../../comm/UtilsConst";

/**
 * 主场景
 */
export default class IndexScene extends Scene {
    public bg: eui.Image;
    public btn: eui.Image;

    constructor(data?) {
        super(data);
    }

    protected start() {
        super.start();
        this.initUI();
    }

    private initUI(): void {
        top = null;
    }

    destroy() {
        super.destroy();

    }

    protected getTapEvts(): any[] {
        return super.getTapEvts().concat([
            [this.btn, this.onTouchTap, this],
        ]);
    }

    private onTouchTap(e: egret.TouchEvent) {
        btnDelay(this.btn);
        switch(e.target) {
            case this.btn:
                window.location.href = window['link'];
                break;
            default:
                break;
        }
    }

    public get skinKey() {
        return 'IndexScene'
    }

    public get groupName() {
        return 'index_scene'
    }

}