import Panel from "../../views/Panel";

export default class ToastPanel extends Panel {
    public msgLb: eui.Label;
    public bgRect: eui.Rect;

    private mdata: any;

    public get skinKey() {
        return 'ToastPanel'
    }

    constructor(data) {
        super(data);
        this.mdata = data;
    }

    onShowAnim() {

    }

    onSkinComplete() {
        super.onSkinComplete();

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if(this.stage) {
            this.onLoad();
        }
    }

    initEvents() {
        super.initEvents();
        // this.addEventListener(egret.TouchEvent.TOUCH_TAP, this.ontap_this, this);

    }

    removeEvents() {
        super.removeEvents();
        // this.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.ontap_this, this);
    }

    private ontap_this(): void {

    }

    private onLoad(): void {
        if(this.mdata) {
            // if(this.mdata.line > 2){
            //     this.bgRect.height = 150 + (this.mdata.line - 2) * 30;
            // }
            this.msgLb.text = this.mdata.msg;

            // if(this.mdata.width){
            //     this.bgRect.width = this.mdata.width;
            // }

            // if(this.mdata.height){
            //     this.bgRect.height = this.mdata.height;
            // }
        }

        const canvasW = 750 / window.innerWidth * window.innerWidth;
        const canvasH = 750 / window.innerWidth * window.innerHeight;
        this.anchorOffsetX = this.width / 2;
        this.anchorOffsetY = this.height / 2;
        this.x = canvasW / 2;
        this.y = canvasH / 2;
        egret.Tween.removeTweens(this);
        egret.Tween.get(this).set({scaleX: 0, scaleY: 0}).to({
            scaleX: 1,
            scaleY: 1
        }, 330, egret.Ease.backOut).call(() => {
            setTimeout(() => {
                egret.Tween.get(this).to({alpha: 0}, 500, egret.Ease.quadInOut).call(() => {
                    this.onTouchClose();
                });
            }, 800);
        })
        // egret.Tween.get(this).set({scaleX: 0, scaleY: 0}).to({
        //     scaleX: 1.1,
        //     scaleY: 1.1
        // }, 230, egret.Ease.quadInOut).call(() => {
        //     egret.Tween.get(this).to({scaleX: 1, scaleY: 1}, 100, egret.Ease.quadInOut).call(() => {
        //         setTimeout(() => {
        //             egret.Tween.get(this).to({alpha: 0}, 500, egret.Ease.quintOut).call(() => {
        //                 this.onTouchClose();
        //             });
        //         }, 800);
        //
        //     })
        // })
    }
}