/**
 * 解析Svga，并对videoItem做缓存
 * @author haiyoucuv
 */

import MovieClip = egret.MovieClip;

const videoItems = {};
const parser = new window["SVGA"].Parser();
const EgretMovieClip = window["SVGA"].EgretMovieClip;
export const loadSvga = async (url: string, parent?: egret.DisplayObjectContainer): Promise<MovieClip> => {
    const getMv = (videoItem): MovieClip => {
        const mv = new EgretMovieClip(videoItem);
        mv.gotoAndPlay(1, true);
        if (parent) parent.addChild(mv);

        // mv.addEventListener(egret.Event.COMPLETE, () => {
        //     // console.log("播放完成")
        // }, this);

        return mv;
    }

    if (videoItems[url]) return getMv(videoItems[url]);

    return new Promise((resolve, reject) => {
        parser.load(url, (videoItem) => {
            videoItems[url] = videoItem;
            resolve(getMv(videoItem));
        }, (error) => {
            reject(error.message);
        });
    });
};
