// // 用法示例:
// // 创建一个形状
// function getShape(x, y, w, h) {
//     let newShape = new egret.Shape();
//     newShape.graphics.beginFill(0x000000);
//     newShape.graphics.drawRect(x, y, w, h);  // 要镂空的大小和位置
//     newShape.graphics.endFill();
//     return newShape;
// }
//
// let shape = getShape(100, 100, 100, 100);
// let rMask = new ReverseMask(shape);   // 创建一个ReverseMask
// this.addChild(rMask);    // 加入场景
//
// // 使用缓动改变镂空位置
// // 使用缓动改变 hole 的位置或透明度，需要监听onChange设置为render函数
// egret.Tween.get(rMask.hole, {onChange: rMask.render}).to({x: 500, y: 500, alpha: 0.7}, 1000).call(() => {
//     egret.Tween.get(rMask.hole, {onChange: rMask.render}).to({x: 200, y: 800, alpha: 1}, 1000).call(() => {
//         rMask.setMask({x: 100, y: 100, w: 800, h: 800});    // 直接对mask进行重设
//
//         let shape2 = getShape(300, 300, 150, 150);
//         rMask.hole = shape2;    // 直接对hole赋值进行重设
//     });
// })

/**
 * 简单的反向遮罩
 */
export default class ReverseMask extends eui.Component {
    private canvasW: number = 750 / window.innerWidth * window.innerWidth;
    private canvasH: number = 750 / window.innerWidth * window.innerHeight;

    private _hole: egret.Shape;
    public get hole() {
        return this._hole;
    }

    public set hole(hole: egret.Shape) {
        this._hole = hole;
        this.setShape(this._rect);
    }

    private _shape: egret.Sprite;
    private __mask: egret.Shape = new egret.Shape(); // 外面的遮罩
    private _rect: { x, y, w, h };  // x, y, w 宽，h 高

    constructor(hole: egret.Shape, rect?: { x, y, w, h }) {
        super();
        this._hole = hole;
        this._rect = rect || {x: 0, y: 0, w: this.canvasW, h: this.canvasH};

        this.setMask(rect);
    }

    ///////////////////// Public Method /////////////////////
    public render = () => {
        let renderTex = new egret.RenderTexture();
        renderTex.drawToTexture(this._shape);
        this['__shape'] = new egret.Bitmap(renderTex);
        this.mask = this['__shape'];
        !this['__shape'].parent && this.addChild(this['__shape']);
    };

    public setMask(rect?: { x, y, w, h }) {
        this.__mask.graphics.clear();
        this.__mask.graphics.beginFill(0x000000, 0.65);
        if(rect) {
            this.__mask.graphics.drawRect(rect.x, rect.y, rect.w, rect.h);
        } else {
            this.__mask.graphics.drawRect(0, 0, this.canvasW, this.canvasH);
        }
        this.__mask.graphics.endFill();
        this.addChild(this.__mask);

        this.setShape(rect);
    }

    ///////////////////// Private Method /////////////////////
    private setShape(rect?: { x, y, w, h }) {
        this._shape = new egret.Sprite();
        this._shape.graphics.beginFill(0xffffff);
        if(rect) {
            this._shape.graphics.drawRect(rect.x, rect.y, rect.w, rect.h);
        } else {
            this._shape.graphics.drawRect(0, 0, this.canvasW, this.canvasH);
        }
        this._shape.graphics.endFill();

        this._hole.blendMode = egret.BlendMode.ERASE;
        this._shape.addChild(this._hole);

        this.render();
    }
}