import {ModuleTypes} from "../../types/sceneTypes";
import SceneCtrl from "../../ctrls/sceneCtrl";
import Scene from "../../views/Scene";
import {btnDelay} from "../../comm/UtilsConst";
import PanelCtrl from "../../ctrls/panelCtrl";
import Medal from "./Medal";
import {Tools} from "../../Tools";
import {loadSvga} from "../../comm/loadSvga";
import {getSvga} from "../../utils";

export default class RoomScene extends Scene {
    public group: eui.Group;
    public root: eui.Group;
    public bg: eui.Image;
    public backBtn: eui.Image;
    public farm: eui.Image;
    public market: eui.Image;
    public medals: eui.Group;
    public ad: eui.Image;
    public nickname: eui.Label;
    public panda: eui.Image;
    public table: eui.Image;

    private medalsArr: Medal[] = [];

    constructor(data?) {
        super(data);
    }

    protected start() {
        super.start();
        this.initUI();
        if (this.data && this.data.auto) {
            PanelCtrl.instance.show(ModuleTypes.MEDALS_PANEL);
        }
    }

    private async initUI() {
        this.group.height = 750 / window.innerWidth * window.innerHeight;
        let userInfo = Tools.consumerInfo;
        this.nickname.text = ((!userInfo || !userInfo.nickname || (userInfo.nickname == 'null'))
            ? '小e' : ((userInfo.nickname.length > 4) ? userInfo.nickname.slice(0, 3) + '...' : userInfo.nickname)) + '的小屋';

        const showMedal = [];
        for (let k in Tools.medalData) {
            // if (Tools.medalData[k].status) showMedal.push(Tools.medalData[k]);
            showMedal.push(Tools.medalData[k]);
        }

        showMedal.forEach((v) => {
            const index = v.index;
            const newMedal = new Medal({
                ...v,
                name: '',
                total: showMedal.length
            });
            this.medals.addChild(newMedal);
            newMedal.scaleX = newMedal.scaleY = 0.33;

            newMedal.x = index % 3 * 56 + 25;
            newMedal.y = 68 + ~~(index / 3) * 64;
        });

        const mv = await loadSvga(getSvga('panda_house'));

        this.root.addChildAt(mv, this.root.numChildren - 1);

        // @ts-ignore
        mv.gotoAndPlay(1, true);
    }

    destroy() {
        super.destroy();
        this.medalsArr.forEach(v => v.destroy());
    }

    protected getTapEvts(): any[] {
        return super.getTapEvts().concat([
            [this.backBtn, this.onTouchTap, this],
            [this.medals, this.onTouchTap, this],
            [this.ad, this.onTouchTap, this],
            [this.farm, this.onTouchTap, this],
            [this.market, this.onTouchTap, this],
        ]);
    }

    private onTouchTap(e: egret.TouchEvent) {
        btnDelay(e.target);
        switch (e.target) {
            case this.backBtn:
                btnDelay(this.backBtn);
                egret.Tween.get(this.backBtn)
                    .to({scaleX: 1.2, scaleY: 0.8}, 80)
                    .to({scaleX: 1, scaleY: 1}, 80)
                    .call(() => {
                        SceneCtrl.instance.change(ModuleTypes.MAIN_SCENE);
                    });
                // SceneCtrl.instance.change(ModuleTypes.MAIN_SCENE);
                break;

            case this.medals:   // 勋章墙
                PanelCtrl.instance.show(ModuleTypes.MEDALS_PANEL);
                break;

            case this.ad:   // 广告
                // window.location.href = 'https://www.baidu.com/';
                console.log('广告');
                break;
            case this.farm: // 农场相框
                console.log('农场相框');
                break;
            case this.market:   // 集市
                window.location.href = window['marketLink'];
                console.log('集市');
                break;
            default:
                break;
        }
    }


    public get skinKey() {
        return 'RoomScene'
    }

    public get groupName() {
        return 'room'
    }
}
