import {getSkinPath} from "../../utils";
import TouchEvent = egret.TouchEvent;
import TopLayerCtrl from "../../ctrls/topLayerCtrl";
import {ModuleTypes} from "../../types/sceneTypes";

export default class Medal extends eui.Component {
    public img: eui.Image;
    public light_mask: eui.Image;
    public label: eui.Label;
    public light: eui.Image;

    private data = null;

    constructor(data?: { spId: string, status: boolean, index: number, name?: string, timestamp: number, total }) {
        super();
        this.skinName = getSkinPath('Objs/Medal');
        this.data = data || null;
        this.initUI();  // 设置显示
    }

    private initUI() {

        const {spId, status, index, name, total} = this.data;

        this.label.text = name

        if (status) {
            this.img.source = `medal_${spId}_png`;
            this.light_mask.source = `medal_${spId}_png`;
            this.label.textColor = 0xFFE595;

            const duration = 1000;
            const wait = 1000;
            setTimeout(() => {
                egret.Tween.get(this.light, {loop: true})
                    .set({x: -90})
                    .to({x: 100}, duration)
                    .wait(total * duration);
            }, duration * index + wait);
        } else {
            this.img.source = `medal_${spId}_0_png`;
            this.light_mask.source = `medal_${spId}_0_png`;
            this.label.textColor = 0xbbbbbb;
        }

        if(spId != 'wait'){
            this.addEventListener(TouchEvent.TOUCH_TAP, () => {
                TopLayerCtrl.instance.show(ModuleTypes.MEDAL_PANEL, this.data, 0.7);
            }, this);
        }

        this.light.mask = this.light_mask;

    }

    public destroy() {
        egret.Tween.removeTweens(this.light);
    }
}