import Panel from "../views/Panel";
import {Tools} from "../Tools";
import {NetManager} from "../../libs/tw/manager/NetManager";
import {btnDelay, showToast} from "../comm/UtilsConst";
import {G_GetHomeDataByKey, G_UpdateHomeData, HOME} from "../Scenes/Home";
import {getlogItem} from "../comm/getlogItem";
import {MainIns} from "../Scenes/MainScene/MainScene";

export default class UnlockPanel extends Panel {
    public closeBtn: eui.Image;
    public label: eui.Label;
    public cancel: eui.Button;
    public btn: eui.Button;


    public get skinKey() {
        return 'UnlockPanel'
    }

    public get groupName() {
        return 'unlock_panel'
    }

    constructor(data?) {
        super(data);
    }

    onShowAnim() {
        egret.Tween.get(this).set({alpha: 0}).to({alpha: 1}, 233, egret.Ease.quadInOut);
    }

    protected getTapEvts(): any[] {
        return super.getTapEvts()
            .concat([
                [this.btn, this.onTap, this],
                [this.cancel, this.onTap, this],
            ]);
    }

    private onTap(e) {
        btnDelay(e.target);
        switch (e.target) {
            case this.btn:
                NetManager.ins.clickLog(getlogItem(10));

                const landId = this.data.landId;
                const price = +Tools.areaPrice[landId].price;

                if (G_GetHomeDataByKey(HOME.GOLD) < price) {
                    showToast('欢趣豆不足，快去赚欢趣豆吧');
                    this.hidePanel();
                    return;
                }

                Tools.creditsCost('area', 'join', price, 'act_name').then((ticket) => {
                    NetManager.ins.unlockLand((success) => {
                        if (!success) return;

                        // M_UpdateLand(landId);    TODO 放到动画结束的地方
                        this.data.call();

                        MainIns().mainUI.getPropInfo();

                    }, ticket, landId);
                }).catch(() => {
                    showToast('消耗欢趣豆失败，请稍后再试');

                    G_UpdateHomeData();
                });

                this.hidePanel();

                break;

            case this.cancel:
                this.hidePanel();
                break;
        }
    }

    protected start() {
        super.start();

        this.initUI();
    }

    private initUI(): void {
        this.label.text = `增加一块可使用的土地\n需要消耗${Tools.areaPrice[this.data.landId].price}欢趣豆`;
        NetManager.ins.showLog(getlogItem(10));
    }

    destroy() {
        super.destroy();
    }

}
