import Panel from "../views/Panel";
import { getSkinPath } from "../utils";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { productData } from "./WareHousePanel";

export default class SellRecord extends Panel {
    public list: eui.List;

    public get skinKey() {
        return 'SellRecord'
    }

    public get groupName() {
        return 'sellRecord'
    }

    constructor(data?) {
        super(data);

    }

    onShowAnim() {
        // const canvasH = 750 / window.innerWidth * window.innerHeight;
        egret.Tween.get(this).set({alpha: 0}).to({alpha: 1}, 233, egret.Ease.quadInOut);
    }

    protected start() {
        super.start();

        this.initUI();
    }

    private initUI(): void {
        this.y = 750 / window.innerWidth * window.innerHeight * 0.1;
        this.getSellInfo();
    }

    private getSellInfo() {
        NetManager.ins.getSellInfo((success, res) => {
            if(!success) {
                return;
            }
            const data = res.data;
            this.list.useVirtualLayout = false;
            this.list.itemRenderer = SellRecordItem;
            this.list.dataProvider = new eui.ArrayCollection(data);
        });
    }
}

////////////////////////////////////////////////////////////////////////////////////////////////

// 任务中心列表
class SellRecordItem extends eui.ItemRenderer {
    public dateLabel: eui.Label;
    public cropLabel: eui.Label;
    public creditsLabel: eui.Label;

    constructor() {
        super();
        this.skinName = getSkinPath('SellRecordItem');
    }

    dataChanged() {
        let {date, spCount, sp, credits} = this.data;
        let nd = new Date(date);
        this.cropLabel.text = spCount + productData[sp].numLabel + productData[sp].nameLabel;
        this.dateLabel.text = `${nd.getFullYear()}.${nd.getMonth() + 1}.${nd.getDate()}`;
        this.creditsLabel.text = `${credits}个欢趣豆`;
    }
}
