import Panel from "../views/Panel";
import {HtmlTextParser} from "../../libs/tc/util/HtmlTextParser";
import TopLayerCtrl from "../ctrls/topLayerCtrl";
import {DataManager} from "../../libs/tw/manager/DataManager";
import {NetName} from "../../libs/tw/enum/NetName";
import {htmlToPureText} from "../Scenes/MainScene/Const";
import log = egret.log;

export default class RulePanel extends Panel {
    public closeBtn: eui.Button;
    public ruleLabel: eui.Label;

    public get skinKey() {
        return 'RulePanel'
    }

    constructor(data?) {
        super(data);

    }

    protected start() {
        TopLayerCtrl.instance.closeCurrent();
        TopLayerCtrl.instance.removeMask();
        super.start();
        this.initUI();

    }

    private initUI(): void {
        // let rule = DataManager.ins.getData(NetName.GET_RULE).data || '';
        let rule = window['rule'];
        this.ruleLabel.textFlow = new HtmlTextParser().parser(rule);
    }
}
