import Panel from "../views/Panel";
import TouchEvent = egret.TouchEvent;
import {NetManager} from "../../libs/tw/manager/NetManager";
import {btnDelay, showToast} from "../comm/UtilsConst";
import {getToken} from "../Scenes/MainScene/Const";
import {G_UpdateHomeData} from "../Scenes/Home";
import {MainIns} from "../Scenes/MainScene/MainScene";
import {wait} from "../comm/GameConst";
import {getlogItem} from "../comm/getlogItem";

export default class NewUserPanel extends Panel {
    public closeBtn: eui.Button;
    public btn: eui.Button;

    public get skinKey() {
        return 'NewUserPanel'
    }

    public get groupName() {
        return 'newUser_panel'
    }

    constructor(data?) {
        super(data);

    }

    protected start() {
        super.start();

        NetManager.ins.showLog(getlogItem(18));
        this.y -= 80;
    }

    public initEvents() {
        super.initEvents();
        this.btn.addEventListener(TouchEvent.TOUCH_TAP, this.hidePanel, this);
    }

    public removeEvents() {
        super.removeEvents();
        this.btn.removeEventListener(TouchEvent.TOUCH_TAP, this.hidePanel, this);
    }

    public async hidePanel() {
        super.hidePanel();

        btnDelay(this.btn);
        btnDelay(this.closeBtn);

        NetManager.ins.clickLog(getlogItem(18));

        this.data.f();
    }

}
