import Panel from "../views/Panel";
import Medal from "../Scenes/RoomScene/Medal";
import Tween = egret.Tween;
import {Tools} from "../Tools";
import Ease = egret.Ease;
import To = egret.tween.To;

export default class MedalsPanel extends Panel {
    public closeBtn: eui.Button;
    public sGroup: eui.Group;
    public tipImg: eui.Image;

    private medals: Medal[] = [];

    public get skinKey() {
        return 'MedalsPanel'
    }

    public get groupName() {
        return 'medals';
    }

    constructor(data?) {
        super(data);
    }

    public onShowAnim() {
        // 位置：0.33s(屏幕外)-0.83s(下移1270px至于原位)；
        // 旋转：0.83s(顺时针5度)-1s(逆时针5度)-1.17s(顺时针2度)-1.33s(0度)；
        this.anchorOffsetX = 750 / 2;
        this.x = 750 / 2;
        Tween.get(this)
            .set({y: -870, rotation: 5})
            .wait(330)
            .to({y: 200}, 500, egret.Ease.quartOut)
            .to({rotation: -5}, 170)
            .to({rotation: 2}, 170)
            .to({rotation: 0}, 160);
    }

    protected hideAnim(): Tween {
        let _y = 570 - (1624 - 750 / window.innerWidth * window.innerHeight) / 2;
        Tween.get(this).wait(400).to({alpha: 0}, 100);
        return Tween.get(this).to({x: 510, y: _y, scaleX: 0.1, scaleY: 0.1}, 500, Ease.getPowOut(5));
    }

    protected start() {
        super.start();
        this.initUI();
    }

    private initUI(): void {
        let index = 0;

        let total = 0;

        for (let k in Tools.medalData) {
            if (Tools.medalData[k].status) total++;
        }

        for (let k in Tools.medalData) {
            const i = Tools.medalData[k].index;
            const newMedal = new Medal({
                ...Tools.medalData[k],
                total,
            });
            this.sGroup.addChild(newMedal);
            this.medals.push(newMedal);

            newMedal.x = i % 3 * 175 + 50;
            newMedal.y = 45 + ~~(i / 3) * 230;
            index++;
        }

        for (let i = 0; i < 2; i++) {
            const newMedal = new Medal({
                index, spId: 'wait',
                name: '敬请期待', timestamp: 0, status: false,
                total,
            });
            this.sGroup.addChild(newMedal);
            this.medals.push(newMedal);

            newMedal.x = index % 3 * 175 + 50;
            newMedal.y = 45 + ~~(index / 3) * 230;
            index++;
        }

        this.tipImg.visible = index > 6;
    }

    public destroy() {
        super.destroy();
        this.medals.forEach(v => v.destroy());
    }
}


