import Panel from "../views/Panel";
import Tween = egret.Tween;
import {NetManager} from "../../libs/tw/manager/NetManager";
import {getlogItem} from "../comm/getlogItem";
import TouchEvent = egret.TouchEvent;

export const medalDesc = {
    achv_internship_farmer: {
        desc: '种植达到50次',
        bid: 28,
    },
    achv_advanced_farmer: {
        desc: '种植达到80次',
        bid: 29,
    },
    achv_well_breeder: {
        desc: '养殖奶牛和小鸡共计达50次',
        bid: 30,
    },
    achv_excellent_farmer: {
        desc: '种植达到200次',
        bid: 31,
    },
}

export default class MedalPanel extends Panel {
    public closeBtn: eui.Button;
    public title: eui.Label;
    public desc: eui.Label;
    public date: eui.Label;
    public light_point: eui.Image;
    public light: eui.Image;
    public medal: eui.Image;
    public mask: eui.Image;
    public swap_light: eui.Image;

    constructor(data?) {
        super(data);
    }

    public onShowAnim() {
        // 缩放：0s(0%,0%)-0.23s（120%，120%）-0.33s(100%,100%);
        // 文案和按钮 透明度：0.33s(0%)-0.67s(100%);
        this.anchorOffsetX = 750 / 2;
        this.anchorOffsetY = 900 / 2;
        this.x = 750 / 2;
        this.y = 750 / window.innerWidth * window.innerHeight * 0.15 + 900 / 2;
        Tween.get(this)
            .set({scaleX: 0, scaleY: 0})
            .to({scaleX: 1.2, scaleY: 1.2}, 230)
            .to({scaleX: 1, scaleY: 1}, 100);
    }

    protected onShowAnimCall() {
        Tween.get(this.title)
            .set({alpha: 0})
            .wait(330)
            .to({alpha: 1}, 340);
    }

    protected getTapEvts(): any[] {
        return super.getTapEvts().concat([]);
    }

    protected start() {
        super.start();
        this.initUI();
    }

    private initUI(): void {

        const {name, spId, timestamp, status} = this.data;

        this.title.text = name;
        this.desc.text = medalDesc[spId].desc;

        if (status) {

            // 旋转背景光
            Tween.get(this.light, {loop: true}).to({rotation: 360}, 6000);

            const d = new Date(timestamp);
            this.date.text = `${d.getFullYear()}.${d.getMonth() + 1}.${d.getDate()}获得勋章`;

            this.medal.source = `medal_${spId}_png`;
            this.mask.source = `medal_${spId}_png`;


            // 获得勋章的扫光动效
            Tween.get(this.swap_light, {loop: true})
                .set({x: 50})
                .wait(670)
                .to({x: 550}, 2000)
                .wait(1000);

            NetManager.ins.showLog(getlogItem(medalDesc[spId].bid));
            this.addEventListener(TouchEvent.TOUCH_TAP, () => {
                NetManager.ins.clickLog(getlogItem(medalDesc[this.data.spId].bid));
            }, this);

        } else {
            this.date.text = '你还未获得该勋章';

            this.light.visible = false;
            this.swap_light.visible = false;
            this.light_point.visible = false;

            this.medal.source = `medal_${spId}_0_png`;

        }

        this.swap_light.mask = this.mask;

    }

    public get skinKey() {
        return 'MedalPanel'
    }

    public get groupName() {
        return 'medal_panel';
    }
}